# coding=utf-8
from plugins.CSDR_CSHA_VHA.common.csdr_login_serviceom import LoginServiceOm
import utils.common.log as logger
from utils.common.exception import FCUException
from retrying import retry


class DeleteFlavor(LoginServiceOm):
    """
    调测预配置资源清理
    """
    def __init__(self, project_id):
        LoginServiceOm.__init__(self, project_id)

    @retry(stop_max_attempt_number=3, wait_fixed=30000)
    def delete_flavor_om_service(self, flavor_id):
        '''delete flavor om service'''
        try:
            logger.info("delete flavor om service")
            res_url = "solightuikitservice/rest/v1/command/ecs"
            request_body = {
                             "ci": "Flavors",
                             "action": "Delete",
                             "attrValues": {
                                "pod": self.openstack_region,
                                "FlavorId": flavor_id
                            }
                        }
            res = self.host_and_tool.request_msg('POST',
                                                 res_url,
                                                 request_body,
                                                 self.header)
            state_code = res[0]
            error_msg = res[2]
            if state_code == 200 and error_msg.get("ret_code") == "00000000":
                return True
            if state_code == 200 and error_msg.get("ret_code") != "00000000":
                raise FCUException(40013, flavor_id, error_msg.get("ret_msg"))
            else:
                logger.error("delete flavor failed,error msg is %s"
                             % error_msg.get("ret_msg"))
                raise FCUException(40014, state_code)
        except Exception as error:
            raise error

    def delete_flavor_tag(self, name,
                          resource_type="flavor"):
        '''
        :param flavor_id: 规格id
        :param name: 显示名称和默认名称
        :param resource_type:
        :return:
        '''
        # 查询ccs 标签，如果已经删除，则不再删除。
        exist_flavor= self.query_ccs_flavor(name)
        if not exist_flavor:
            return
        try:
            logger.info("delete flavor ccs tage")
            res_url = "solightuikitservice/rest/v1/command/frameworkpkg"
            request_body = {"ci": "CCS",
                            "action": "DeleteResourceTag",
                            "attrValues":
                                {"ResourceId": exist_flavor,
                                 "ResourceType": resource_type
                                 }
                            }

            res = self.host_and_tool.request_msg('POST',
                                                 res_url,
                                                 request_body,
                                                 self.header)
            resp_message = res[2]
            if res[0]!= 200 or resp_message.get("ret_code") != '00000000':
                error_msg = resp_message.get("ret_msg")
                logger.error("ret_msg is %s" % error_msg)
                raise Exception("delete flavor failed error_msg:%s"
                                % error_msg)
        except Exception as error:
            raise error

    def delete_image(self):
        """
        :return:
        """
        try:

            self.upload_image_name = 'FCU_preconfig_test_img'
            self.img_id = None
            res = self.query_images_list()
            for i in res:
                if self.upload_image_name == i["name"]:
                    self.img_id = i["id"]
            res_url = "solightuikitservice/rest/v1/command/ims"
            logger.info("delete image on solightuikitservice/rest/v1/command/ims")
            request_body = {"ci": "Image", "action": "Delete",
                            "attrValues":
                                {"image_id": self.img_id,
                                 "name": self.upload_image_name}}
            logger.info("start to delete fcu test image name:%s ,\
            request body is:%s" % (self.upload_image_name,str(request_body)))
            res = self.host_and_tool.request_msg("POST", res_url, request_body, self.header)
            if res[2].get("ret_code","00000001")!= "00000000":
                logger.error("delete image failed")
                raise Exception("request to delete image failed")
            logger.info("delete fcu test image %s Success" % self.upload_image_name)
        except Exception as error:
            raise error









