# coding=utf-8
import os

from utils.client.Openstack_OM_client import OPENSTACK_OMUIClient
from platforms.param.ParamManager import ParamService
from utils.business.param_util import ParamUtil
import utils.common.log as logger
from utils.common.exception import FCUException
from platforms.utils.file_util import read_conf


class LoginServiceOm(object):
    """
    登录serviceom 创建规格及外部网络
    """

    def __init__(self, project_id):
        self.db_obj = ParamService()
        self.project_id = project_id
        self.project_info = self.db_obj.get_project_info(project_id)
        self.region_id = self.project_info.get('region_id')
        self.region_type = self.project_info.get('region_type').lower()
        self.params = ParamUtil()
        self.web_ui_account = 'admin'

        params = ParamUtil()

        self.service_om_ip = params.get_value_from_cloud_param(
            self.project_id, 'CSDR',
            'tc_first_region_serviceom_ip', self.region_id)

        self.service_om_init_password = params.get_value_from_cloud_param(
            self.project_id, 'CSDR',
            'tc_first_region_serviceom_password',
            self.region_id)

        self.openstack_region = params.get_value_from_cloud_param(
            self.project_id, 'CSDR',
            'tc_first_region_openstack_region',
            self.region_id)

        self.parent_dir = os.path.dirname(os.path.realpath(__file__))
        self.port = read_conf(
            os.path.join(self.parent_dir, "upgrade_test.ini")).\
            get("common", "serviceom_port")

        self.auth_provider = {
            "ip": self.service_om_ip,
            "port": self.port,
            "user_name": self.web_ui_account,
            "pwd": self.service_om_init_password,
            "clientIP": self.service_om_ip}
        self.host_and_tool = OPENSTACK_OMUIClient(self.auth_provider)
        self.header = self.host_and_tool._build_default_head()


    def query_ccs_flavor(self, flavor_name):
        """
        :param flavor_name:
        :return:
        """
        res_url = "solightuikitservice/rest/v1/command/frameworkpkg"
        logger.info("query_flavor ccs tag url is : %s" % res_url)
        request_body ={
                        "ci": "CCS",
                        "action": "QueryResourceTag",
                        "attrValues": {
                            "ResourceType": "flavor"
                        }
                    }
        logger.info("query_flavor request_body is: %s" % request_body)
        try:
            res = self.host_and_tool.request_msg("POST",
                                                 res_url,
                                                 request_body,
                                                 self.header)
            resp_message = res[2]
            logger.info("query_flavor res message is :%s" % resp_message)
            if res[0] == 200 and resp_message.get("ret_code") == '00000000':
                flavor_info = resp_message.get("data")["data"]
                for each in flavor_info:
                    flavor_id = each['resource_id']
                    env_flavor_name = each.get("tags").get("name")[0]
                    display_name = each.get("tags").get("display_name")[0]
                    if flavor_name == env_flavor_name and \
                       flavor_name == display_name:
                        logger.info("flavor_id is %s :" % flavor_id)
                        return flavor_id
                else:
                    logger.info("No flavor is found for the name: %s"
                                % flavor_name)
                    return None
            else:
                raise FCUException(40028, res[0], flavor_name)
        except Exception as error:
            raise error


    def query_flavor(self, flavor_name):
        """
        :param flavor_name:
        :return:
        """
        res_url = "solightuikitservice/rest/v1/command/ecs"
        logger.info("query_flavor url is : %s" % res_url)
        request_body ={
                        "ci": "Flavors",
                        "action": "QueryList",
                        "attrValues": {
                            "pod": self.openstack_region
                        }
                    }
        try:
            res = self.host_and_tool.request_msg("POST",
                                                 res_url,
                                                 request_body,
                                                 self.header)
            resp_message = res[2]
            logger.info("query_flavor res message is :%s" % resp_message)
            if res[0] == 200 and resp_message.get("ret_code") == '00000000':
                flavor_info = resp_message.get("data")["data"]
                for each in flavor_info:
                    flavor_id = each.get("id")
                    env_flavor_name = each.get("name")
                    if flavor_name == env_flavor_name:
                        logger.info("flavor_id is %s :" % flavor_id)
                        return flavor_id
                else:
                    logger.info("No flavor is found for the name: %s"
                                % flavor_name)
                    return None
            else:
                raise FCUException(40028, res[0], flavor_name)
        except Exception as error:
            raise error



