import traceback
import time
from .CSBSTestBaseAW_new import TenantApi, CheckOrderError, remove_sensitive_info
import utils.common.log as logger
from utils.common.message import Message


class CreateTestVM(object):
    def __init__(self, project_id, pod_id, regionid_list=None):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装&配置
        :return: Message对象
        """
        try:
            logger.info('Start to create the test vm')
            tenant_api = TenantApi(project_id)
            # 创建vpc
            tenant_api.create_vpc()
            # 创建密钥对
            tenant_api.create_keypair(tenant_api.keypair_name)
            vm_ino = tenant_api.get_vm_info(tenant_api.server1_name)
            if vm_ino:
                if vm_ino["status"].upper() != 'ACTIVE':
                    logger.info('the vm already exists, but status is not ACTIVE, begin to delete it')
                    tenant_api.delete_vm(tenant_api.region_name, [{'name': tenant_api.server1_name}])
                    time.sleep(10)
                else:
                    logger.info('The vm already exists, status is ACTIVE, no need to create it')
                    return Message(200)
            for vol_type_name in tenant_api.volume_type_list:
                vm1_ino = tenant_api.set_vm_info(vol_type=vol_type_name)
                logger.info('Current vm info:{}'.format(vm1_ino))
                try:
                    logger.info('Try to use the volume type:{} to create a vm'.format(vol_type_name))
                    tenant_api.create_vm(tenant_api.region_name, [vm1_ino])
                    logger.info('Succeed to create the test vm')
                except CheckOrderError as e:
                    logger.error('Checking order status is failed, '
                                 'errMsg:{}, use next volume type creating the vm'.format(e))
                    continue
                except Exception as e:
                    logger.error('Failed creating vm,errMsg:{}'.format(e))
                    raise e
                else:
                    return Message(200)
            logger.error('Failed creating vm with all volume types')
            return Message(500, "使用所有卷类型创建虚拟机失败",
                           "Failed creating vm with all volume types",
                           "请检查订单状态及请求参数",
                           "Please check the order status and request parameters")

        except Exception as e:
            error = str(e)
            logger.error("Failed to create test vm, "
                         "errMsg= {}".format(remove_sensitive_info(traceback.format_exc())))
            return Message(500, "创建测试虚拟机失败[%s]" % error,
                           "Failed to create vm[%s]" % error,
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
