import traceback
from .CSBSTestBaseAW_new import TenantApi, remove_sensitive_info
import utils.common.log as logger
from utils.common.message import Message


class DeleteTestVM(object):
    def __init__(self, project_id, pod_id, regionid_list=None):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装&配置
        :return: Message对象
        """

        try:
            logger.info('Start to delete the test vm')
            tenant_api = TenantApi(project_id)
            vm1_ino = tenant_api.set_vm_info()
            tenant_api.delete_vm(tenant_api.region_name, [vm1_ino])
            logger.info('Succeed to delete the test vm')
            # 删除密钥对
            tenant_api.delete_keypair(tenant_api.keypair_name)
            # 删除vpc
            tenant_api.delete_vpc()
            return Message(200)
        except Exception as e:
            error = str(e)
            logger.error("Failed to delete test vm, "
                         "errMsg={}".format(remove_sensitive_info(traceback.format_exc())))
            return Message(500, "删除测试虚拟机失败[%s]" % error,
                           "Failed to delete vm[%s]" % error,
                           "请检查", "Please check.")

    def rollback(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
