import time
import traceback
from .CSBSTestBaseAW_new import CSBSBaseAWAdapter, CSBSBaseConsoleAdapter, remove_sensitive_info
import utils.common.log as logger
from utils.common.message import Message


class Restore(object):
    def __init__(self, project_id, pod_id, regionid_list=None):
        """

        """

        self.project_id = project_id
        self.pod_id = pod_id
        self.plan_id = None
        self.backup_info = None
        self.backup_info1 = None

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        pass

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行安装&配置
        :return: Message对象
        """
        try:
            instance = CSBSBaseAWAdapter(project_id)
            logger.info("Start getting IAM authentication")
            login_status_code, login_res = instance.login_iam()
            if login_status_code != 201:
                return Message(500, "登录IAM鉴权失败.",
                               "Login IAM failed.",
                               "请检查IAM域名及用户登录信息",
                               "Please check iam_ip and user info.")
            logger.info("Login to IAM successfully")
            logger.info("Check before executing scripts")
            instance.Check_setup()
            # 组装resource_list
            resource_list = [{"name": instance.server1_name,
                              "id": instance.server1_id,
                              "type": "OS::Nova::Server"}]
            # 构造策略名字
            plan_name_time = time.strftime("%d%H%M")
            plan_name_body = "csbs_autoplan"
            plan_name = plan_name_body + plan_name_time
            logger.info("Start applying a backup Policy")
            plan_info = instance.SBS_Create_Plan_Incremental_Include_TrueAndFalse_auto(resource_list, plan_name)
            self.plan_id = plan_info[0]
            logger.info("Succeed applying a cloud server's backup policy, id:{i}".format(i=self.plan_id))
            logger.info("Check the console page for the existence of the applied policy"
                        " in the list of cloud server backup policies")
            try:
                # console第一次登陆后cookie可能会超时失效
                info = instance.console.Querying_policy_information()
            except:
                logger.info('Failed logging console, start retrying')
                instance1 = CSBSBaseConsoleAdapter(project_id)
                logger.info("Start getting console authentication")
                instance1.login_sc()
                logger.info("Succeed getting console authentication")
                info = instance1.Querying_policy_information()
            if plan_info[0] in str(info):
                logger.info("After checking, the policy exists")
            else:
                return Message(500, "经过检查，策略不存在，请检查原因",
                               "After checking, the policy does not exist, please check the reason")

            logger.info("Manual triggering of an incremental backup to get a copy")
            self.backup_info = instance.SBS_BackupManualorAuto_BackupManualorAuto(plan_info[0], plan_info[1])
            logger.info("Use the copy to restore to the original server")
            instance.common_Restore(self.backup_info[1])
            instance.common_Wait_Image_Status_Except(self.backup_info[0])
            # 清理
            instance.teardown(plan_id=self.plan_id)
            instance.teardown(self.backup_info[1], self.backup_info[0])
            instance.Check_Teardown()
            logger.info('All finish')
            return Message(200)
        except Exception as e:
            error = str(e)
            logger.error('Error stack: {}'.format(remove_sensitive_info(traceback.format_exc())))
            return Message(500, "运行出错，出错原因：{}。详细错误信息请检查日志".format(error),
                           "Run error, cause of error: {}, "
                           "please check logs to get detailed error message ".format(e))

    def rollback(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
