import time

from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from plugins.CSBS_VBS.common.scripts import cbs_karborclient as karbor_client
from utils.common.exception import FCUException
from utils.business.param_util import ParamUtil

logger.init("CSBS-VBS")


class ConfigCertManage(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.service_name = "CSBS-VBS"
        params = Params(project_id, pod_id, self.service_name,
                        self.regionid_list[0])
        self.db_param_dict = params.get_params()
        self.dmk_config_content = {}
        self.param_util = ParamUtil()

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        try:
            # karbor ssh client
            karbor_node = karbor_client.CBSNode(self.db_param_dict.get("karbor_host0"),
                                                "djmanager",
                                                self.db_param_dict.get("karbor_djmanager_pwd"),
                                                self.db_param_dict.get("karbor_root_pwd"))
            ssh_client = karbor_client.get_sshclient_user_su_root_console(karbor_node)

            # cmc cmd
            get_cmd = "docker exec karborapi cat /etc/karbor/karbor.conf |grep sc_endpoint | awk -F '=' '{print $2}'"
            result = karbor_client.ssh_exec_command_return(ssh_client, get_cmd)
            if not karbor_client.is_ssh_cmd_executed(result):
                karbor_client.ssh_close(ssh_client)
                msg = 'failed to get sc_url on karbor node.'
                raise Exception(msg)

            sc_url = result[0]
            cmc_url = sc_url.replace(':31943', ':26335')
            cmc_cmd = "set_karbor_endpoints --cmc_endpoint %s" % cmc_url

            result = karbor_client.ssh_exec_command_return(ssh_client, cmc_cmd)

            if not karbor_client.is_ssh_cmd_executed(result):
                karbor_client.ssh_close(ssh_client)
                msg = 'failed to execute cmd set_karbor_endpoints on karbor node.'
                raise Exception(msg)

        except Exception as ex:
            logger.error(ex)
            return Message(500, FCUException(645002))

        try:
            # config console node info on karbor node
            config_result = False
            for index_ in range(3):
                config_result = self.config_console(ssh_client)
                if config_result:
                    logger.info("Config console node info success.")
                    break
                else:
                    msg = 'Failed to config console info, ' \
                          'retry num is: %s.' % index_
                    logger.error(msg)
                    time.sleep(10)
            if not config_result:
                raise Exception('Failed to execute cmd set_console_node '
                                'on karbor node.')
            karbor_client.ssh_close(ssh_client)
            return Message(200)

        except Exception as ex:
            logger.error(ex)
            return Message(500, FCUException(645003))

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：检查
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)

    def config_console(self, ssh_client):
        console_usrname = "cbs_admin"
        console_userpwd = self.db_param_dict.get("console_cbs_admin_pwd")
        console_rootpwd = self.db_param_dict.get("console_root_pwd")
        console_ips = ','.join([self.db_param_dict.get("console_host0"),
                                self.db_param_dict.get("console_host1")])

        expect_str = 'Input guest username for login console node:'
        cmds = "set_console_node --ips {}".format(console_ips)
        result = karbor_client.ssh_send_command_expect(ssh_client,
                                                       cmds,
                                                       expect_str + ";# ;$ ")
        if karbor_client.failed_to_return(result, expect_str, ssh_client):
            return False
        expect_str = 'Input the password of guest user:'
        result = karbor_client.ssh_send_command_expect(ssh_client,
                                                       console_usrname,
                                                       expect_str + ";# ;$ ")
        if karbor_client.failed_to_return(result, expect_str, ssh_client):
            return False
        expect_str = 'Confirm password:'
        result = karbor_client.ssh_send_command_expect(ssh_client,
                                                       console_userpwd,
                                                       expect_str + ";# ;$ ")
        if karbor_client.failed_to_return(result, expect_str, ssh_client):
            return False
        expect_str = 'Input root username for login console node:'
        result = karbor_client.ssh_send_command_expect(ssh_client,
                                                       console_userpwd,
                                                       expect_str + ";# ;$ ")
        if karbor_client.failed_to_return(result, expect_str, ssh_client):
            return False
        expect_str = 'Input the password of  user:'
        result = karbor_client.ssh_send_command_expect(ssh_client,
                                                       'root',
                                                       expect_str + ";# ;$ ")
        if karbor_client.failed_to_return(result, expect_str, ssh_client):
            return False
        expect_str = 'Confirm password:'
        result = karbor_client.ssh_send_command_expect(ssh_client,
                                                       console_rootpwd,
                                                       expect_str + ";# ;$ ")
        if karbor_client.failed_to_return(result, expect_str, ssh_client):
            return False
        expect_str = 'Commit set console node successfully'
        result = karbor_client.ssh_send_command_expect(ssh_client,
                                                       console_rootpwd,
                                                       expect_str + ";# ;$ ")
        if karbor_client.failed_to_return(result, expect_str, ssh_client):
            return False
        return True
