import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.CSBS_VBS.common.scripts.cbs_accounts import Accounts

logger.init("CSBS-VBS")


class CreateDmkAccount(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.accounts = Accounts(project_id, pod_id, regionid_list)

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        try:
            self.accounts.create_accounts()
        except Exception as ex:
            logger.error("Failed to create DMK Account , reason:%s", str(ex))
            return Message(500, ex, ex)

        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：检查
        :return:Message类对象
        """
        return Message(200)
