from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from plugins.CSBS_VBS.common.scripts import cbs_karborclient as karbor_client

logger.init("CSBS-VBS")


class OnAutoBak(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.service_name = "CSBS-VBS"
        params = Params(project_id, pod_id, self.service_name,
                        self.regionid_list[0])
        self.db_param_dict = params.get_params()
        self.dmk_config_content = {}

    def pre_check(self, project_id, pod_id, regionid_list):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        logger.info("Start to turn on Karbor Automatic Backup.")

        # start karbor operation service
        try:
            cbs_node = karbor_client.CBSNode(
                self.db_param_dict.get("karbor_host0"), "djmanager",
                self.db_param_dict.get("karbor_djmanager_pwd"),
                self.db_param_dict.get("karbor_root_pwd"))
            ssh_client = karbor_client.get_sshclient_user_su_root(cbs_node)

            cmds = "start_service --service karbor-operation"
            result = karbor_client.ssh_exec_command_return(ssh_client, cmds)
            ret = karbor_client.is_ssh_cmd_executed(result)
            if not ret:
                msg = 'Failed to execute cmd start_service on karbor node.'
                logger.error(msg)
                raise Exception(msg)

            logger.info("Turn on automatic backup function success.")
            return Message(200)

        except Exception as e:
            logger.error("Failed to turn on Karbor Automatic Backup, "
                         "reason: %s", str(e))
            return Message(500, e, e)

    def rollback(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list):
        """
        标准调用接口：检查
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:
        """
        return Message(200)
