from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from plugins.CSBS_VBS.common.scripts.cbs_apiadapter import API
from plugins.CSBS_VBS.common.scripts.cbs_params import is_csha_scene
from plugins.CSBS_VBS.common.scripts.cbs_params import is_last_region
from plugins.CSBS_VBS.common.scripts.cbs_params import is_primary_region
from plugins.CSBS_VBS.common.scripts.cbs_params import is_global_dr_scene
from plugins.CSBS_VBS.common.scripts.cbs_params import get_current_upgrade_path
from plugins.CSBS_VBS.common.scripts.cbs_constant import UPGRADE_PATH


class ConfigFiles(object):
    def __init__(self, project_id, pod_id, regionid_list, ex_params=None):
        # step exec info
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        params = Params(project_id, pod_id, "CSBS", self.regionid_list[0])
        self.config_dict = params.get_params() if not ex_params else ex_params
        self.console_dmk_config_content = {}
        self.karbor_dmk_config_content = {}
        self.current_upgrade_path = get_current_upgrade_path(project_id)

    def get_console_config_files(self):
        if not self.console_dmk_config_content:
            self.init_console_config_file()
        return self.console_dmk_config_content

    def get_karbor_config_files(self):
        if not self.karbor_dmk_config_content:
            self.init_karbor_config_file()
        return self.karbor_dmk_config_content

    def get_config(self, db_dict, file_path):
        '''
        @:param dict:读取数据库中对应服务的参数字典，一般为__db_param_dict
                file_path: DMK中部署的配置文件
        @:return 返回由字典自动填充到DMK配置文件后得到的字符串
        '''
        config_str = self.get_config_content(file_path)
        return config_str.format(**db_dict)

    @staticmethod
    def get_config_content(file_path):
        '''
        @:param file_path: DMK中部署的配置文件
        @:return 返回DMK配置文件的字符串
        '''
        with open(file_path, encoding='utf-8') as f:
            config_str = f.read()
            return config_str

    def init_console_config_file(self):
        '''
        :return:
        '''
        # 渲染console upgrade config&host文件
        if not is_primary_region(self.project_id) and is_global_dr_scene(self.project_id):
            # 备Region
            if self.current_upgrade_path in [UPGRADE_PATH.NFVI6311_TO_651,
                                             UPGRADE_PATH.NFVI650_TO_651]:
                template_console_config = \
                    API.SCRIPT_PATH + 'nfvi_console_config'
            else:
                template_console_config = API.SCRIPT_PATH + 'console_config'
            template_console_host = API.SCRIPT_PATH + 'console_host'
            self.console_dmk_config_content['config'] = self.get_config(
                self.config_dict, template_console_config)
            self.console_dmk_config_content['host'] = self.get_config_content(
                template_console_host)

        if is_last_region(self.project_id, self.regionid_list[0]):
            # 最后一个Region
            if self.current_upgrade_path in [UPGRADE_PATH.NFVI6311_TO_651,
                                             UPGRADE_PATH.NFVI650_TO_651]:
                template_console_config = \
                    API.SCRIPT_PATH + 'nfvi_primary_region_console_config'
            else:
                template_console_config = API.SCRIPT_PATH + 'primary_region_console_config'
            template_console_host = API.SCRIPT_PATH + 'primary_region_console_host'
            self.console_dmk_config_content['primary_region_config'] = self.get_config(
                self.config_dict, template_console_config)
            self.console_dmk_config_content['primary_region_host'] = self.get_config_content(
                template_console_host)

    def init_karbor_config_file(self):
        '''
        :return:
        '''
        # 渲染karbor upgrade config&host文件
        if is_csha_scene(self.project_id):
            template_console_config = API.SCRIPT_PATH + 'csha_karbor_config'
            template_console_host = API.SCRIPT_PATH + 'csha_karbor_host'
        else:
            template_console_config = API.SCRIPT_PATH + 'karbor_config'
            template_console_host = API.SCRIPT_PATH + 'karbor_host'

        self.karbor_dmk_config_content['config'] = self.get_config(
            self.config_dict, template_console_config)
        self.karbor_dmk_config_content['host'] = self.get_config_content(
            template_console_host)
