import zipfile
import ast
import os
from configparser import ConfigParser
from utils.DBAdapter.DBConnector import BaseOps
from plugins.CSBS_VBS.common.scripts.cbs_apiadapter import API
from utils.business.param_util import ParamUtil
from platforms.project.ProjectUtils import get_project_conditions
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from  platforms.param.param_service import ParamService
from utils.business.project_util import ProjectApi
from plugins.CSBS_VBS.common.scripts.cbs_constant import VMS_NAME

conf_path = os.path.realpath(__file__ + '../../../conf/upgrade.ini')


class Params(object):
    def __init__(self, project_id, pod_id, service_name, region_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.region_id = region_id
        self.db = BaseOps()
        self.service_name = "CSBS-VBS"
        self.__db_param_dict = {}

    def get_params(self):
        if not self.__db_param_dict:
            self.init_params()
        return self.__db_param_dict

    def init_params(self):
        service_items = API.get_service_param_dict(self.db, self.pod_id,
                                                   self.service_name,
                                                   self.region_id)

        for key, value in service_items.items():
            self.__db_param_dict[key] = value

        dmk_items = API.get_dmk_info(self.pod_id)

        for key, value in dmk_items.items():
            self.__db_param_dict[key] = value

        dmk_business_keys = ["DMK_dmk_os_business_username",
                             "DMK_dmk_os_business_user_password"]
        for key in dmk_business_keys:
            val = ParamUtil().get_param_value(self.pod_id, "DMK", key)
            if val:
                self.__db_param_dict[key] = val

        self.__db_param_dict.update(self.get_vm_ips())

    def get_vmnames(self):
        vm_names = [VMS_NAME.CONSOLE1, VMS_NAME.CONSOLE2, VMS_NAME.KARBOR1, VMS_NAME.KARBOR2, VMS_NAME.KARBOR3]
        vm_names_ha = [VMS_NAME.CONSOLE_HA1, VMS_NAME.CONSOLE_HA2, VMS_NAME.KARBOR_HA1, VMS_NAME.KARBOR_HA2]
        vm_names_no_console = vm_names[2:]
        vm_names_no_console_ha = vm_names_ha[2:]
        # 从region无console
        if not is_primary_region(self.project_id) and not is_global_dr_scene(self.project_id):
            vmNames = vm_names_no_console
            if is_csha_scene(self.project_id):
                vmNames = vm_names_no_console_ha
        else:
            vmNames = vm_names
            if is_csha_scene(self.project_id):
                vmNames = vm_names_ha
        return vmNames

    def get_vm_ips(self):
        vmNames = self.get_vmnames()
        vm_name_keys = ['console_host0', 'console_host1', 'karbor_host0', 'karbor_host1', 'karbor_host2']
        vm_ips = []
        for vm_name in vmNames:
            vm_info = ParamService().get_vm_info_by_vm_name(self.project_id, vm_name)
            if not vm_info:
                raise Exception('Failed getting vm info from vm name, vm name:{}'.format(vm_name))
            vm_ips.append(vm_info[0].get('ip'))
        # 从region参数添加主region console
        if not is_primary_region(self.project_id) and not is_global_dr_scene(self.project_id):
            primary_region_console_ip1 = API.get_user_input_cloud_param_by_key(self.db, self.pod_id,
                                                                               self.service_name,
                                                                               'primary_region_console_ip1')
            primary_region_console_ip2 = API.get_user_input_cloud_param_by_key(self.db, self.pod_id,
                                                                               self.service_name,
                                                                               'primary_region_console_ip2')
            vm_ips.insert(0, primary_region_console_ip1)
            vm_ips.insert(1, primary_region_console_ip2)
        vm_ip_dict = dict(zip(vm_name_keys, vm_ips))
        if is_primary_region(self.project_id):
            vm_ip_dict['primary_region_console_host0'] = vm_ip_dict['console_host0']
            vm_ip_dict['primary_region_console_host1'] = vm_ip_dict['console_host1']
        return vm_ip_dict


# 从升级包名称中获取版本号
def getVersion(package_abs):
    file_fs = None
    try:
        file_fs = zipfile.ZipFile(r'%s' % package_abs, 'r')
        for f in file_fs.namelist():
            if f.endswith(".json"):
                return f.split("-").__getitem__(1)
    except Exception as e:
        if file_fs is not None:
            file_fs.close()
    finally:
        if file_fs is not None:
            file_fs.close()
    return None


# 是否csha场景
def is_csha_scene(project_id):
    db_obj = ParamService()
    project_info = db_obj.get_project_info(project_id)
    base_options = project_info.get('base_options')
    options = ast.literal_eval(base_options)
    if options.get('is_csha_scene'):
        return True
    return False


# 是否主region
def is_primary_region(project_id):
    projectDict = get_project_conditions(project_id)
    isPrimary = projectDict.get("PrimaryRegion")
    if isPrimary:
        return True
    return False


# 是否管理容灾场景
def is_global_dr_scene(project_id):
    projectDict = get_project_conditions(project_id)
    isGlobalDr = projectDict.get("GlobalConDR")
    if isGlobalDr:
        return True
    return False


# 是否最后一个region
def is_last_region(project_id, region_id):
    conf = ConfigParser()
    conf.read(conf_path)
    target_version = conf.get('VERSION', 'target_version')
    region_list_str = conf.get('REGION', 'cbs_region_list')
    region_list = region_list_str.split(',')
    manage = ManageOneCmdbUtil(project_id)
    last_region = manage.judge_last_upgrade_region('CSBS-VBS', target_version,
                                                   region_id, region_list)
    if last_region:
        return True
    return False


# 获取当前升级路径
def get_current_upgrade_path(project_id):
    solution, version = ProjectApi.get_solution_and_version(project_id)
    return '_'.join([solution, version])
