import traceback
import utils.common.log as logger
from utils.business.dmk_util import DmkApi
from utils.common.ssh_util import Ssh
from utils.common.code2Msg import code2Msg
from platforms.param.param_service import ParamService
from platforms.param.param_check_handler import HandleParamCheck
from plugins.CSBS_VBS.common.scripts.cbs_params import is_csha_scene
from plugins.CSBS_VBS.common.scripts.cbs_params import is_global_dr_scene
from plugins.CSBS_VBS.common.scripts.cbs_params import Params
from platforms.project.ProjectUtils import get_project_conditions
from utils.common.param_check import check_param_ip
from utils.common.param_check import check_param_password
from utils.security.crypt import decrypt

CBS_ADMIN = 'cbs_admin'
DJMANAGER = 'djmanager'
ROOT = 'root'
DMK_ACCOUNT_CBS = 'CBS'
DMK_CBS_PWD = 'flzsLyr4gCaRmvYtR/VGDFnKOylC0c5qz7dinztfb/k='


def params_check(project_id):
    """
    插件参数校验接口函数
    错误信息返回值（需要中英文信息）：
        1、支持通过FCUException(error_code, *arg, **kwargs)类获取中英文信息,此方法是获取公共方法中的错误
        2、支持通过code2Msg(error_code, *arg, **kwargs)函数获取中英文信息,此方法是获取各组件自定义的错误
    :param project_id:
    :return:
    """
    db_opt = ParamService()
    check_data = db_opt.get_need_check_cloud_params(project_id, 'CSBS-VBS')
    project_info = db_opt.get_project_info(project_id)
    region_id = project_info.get('region_id')
    params = Params(project_id, project_id, 'CSBS-VBS', region_id)
    vm_ips_dict = params.get_vm_ips()
    logger.info('Current vms info: {}'.format(vm_ips_dict))
    check_result = HandleParamCheck()

    ips = []
    pwds = []
    for key, val in check_data.items():
        if key in pwds and val:
            try:
                if check_param_password(val):
                    check_result.set_check_result(param_keys=[key], status=200,
                                                  error_msg='')
                else:
                    check_result.set_check_result(param_keys=[key], status=500,
                                                  error_msg=code2Msg(642000))
            except Exception as error:
                check_result.set_check_result(param_keys=[key], status=500,
                                              error_msg=error)
        elif key in ips and val:
            try:
                if check_param_ip(val):
                    check_result.set_check_result(param_keys=[key], status=200,
                                                  error_msg='')
                else:
                    check_result.set_check_result(param_keys=[key], status=500,
                                                  error_msg=code2Msg(641000))
            except Exception as error:
                check_result.set_check_result(param_keys=[key], status=500,
                                              error_msg=error)
    # 检查主region dmk连接
    projectDict = get_project_conditions(project_id)
    isPrimary = projectDict.get("PrimaryRegion")
    if not isPrimary:
        global_dmk_float_ip = check_data.get('DMK_Global-DMK-Float-IP')
        dmk_ui_user = DMK_ACCOUNT_CBS
        dmk_ui_pwd = decrypt(DMK_CBS_PWD)
        try:
            dmk_client = DmkApi()
            dmk_client.login_dmk(dmk_ip=global_dmk_float_ip,
                                 user_name=dmk_ui_user,
                                 password=dmk_ui_pwd)
            dmk_client.get_dmk_public_config()
            check_result.set_check_result(param_keys=['DMK_Global-DMK-Float-IP'],
                                          status=200,
                                          error_msg="")
        except Exception as e:
            logger.error(traceback.format_exc())
            logger.error("Failed to login to dmk,"
                         "IP:{}, User:{},errMsg:{}".format(global_dmk_float_ip, dmk_ui_user, str(e)))
            check_result.set_check_result(param_keys=['DMK_Global-DMK-Float-IP'],
                                          status=500,
                                          error_msg=code2Msg(642001))
    # # 校验console IP和密码
    # 主region校验主region连接, 备region校验备region连接
    if isPrimary or (not isPrimary and is_global_dr_scene(project_id)):
        cbsadmin_pwd_check_count = 0
        cbsadmin_pwd_no_ssh_ips = []
        console_root_pwd_check_count = 0
        console_root_pwd_no_ssh_ips = []
        cbsadmin_pwd = check_data["csbs_console_cbsadmin_password"]
        root_pwd = check_data["csbs_console_root_password"]
        check_list1 = ["csbs_console_cbsadmin_password"]
        check_list2 = ["csbs_console_root_password"]

        for console_ip in ['console_host0', 'console_host1']:
            ssh_client = None
            console_host = vm_ips_dict[console_ip]
            try:
                ssh_client = Ssh.ssh_create_client(console_host, CBS_ADMIN, cbsadmin_pwd)
                cbsadmin_pwd_check_count += 1
            except:
                logger.error("Failed to login to Console node: IP %s, User %s" % (console_host, CBS_ADMIN))
                cbsadmin_pwd_no_ssh_ips.append(console_host)

            try:
                Ssh.ssh_send_command(ssh_client, 'sudo su', '[sudo] password for root:', 10)
                Ssh.ssh_send_command(ssh_client, root_pwd, '#', 10)
                console_root_pwd_check_count += 1
            except:
                logger.error("Failed to login to Console node: IP %s, User %s" % (console_host, ROOT))
                console_root_pwd_no_ssh_ips.append(console_host)
            finally:
                try:
                    Ssh.ssh_close(ssh_client)
                except:
                    logger.error("Failed to close ssh client: IP %s" % console_host)
        if cbsadmin_pwd_check_count == 2:
            check_result.set_check_result(param_keys=check_list1, status=200, error_msg='')
        else:
            logger.error("Failed to login to "
                         "Console node: IP %s, User %s" % (','.join(cbsadmin_pwd_no_ssh_ips), CBS_ADMIN))
            check_result.set_check_result(param_keys=check_list1, status=500, error_msg=code2Msg(642001))
        if console_root_pwd_check_count == 2:
            check_result.set_check_result(param_keys=check_list2, status=200, error_msg='')
        else:
            logger.error("Failed to login to "
                         "Console node: IP %s, User %s" % (','.join(console_root_pwd_no_ssh_ips), ROOT))
            check_result.set_check_result(param_keys=check_list2, status=500, error_msg=code2Msg(642001))

    # 从region校验主region连接, 备reigon校验主region连接;
    if not isPrimary:
        cbsadmin_pwd = check_data["csbs_console_cbsadmin_password"]
        root_pwd = check_data["csbs_console_root_password"]
        for console_ip in ['primary_region_console_ip1', 'primary_region_console_ip2']:
            ssh_client = None
            check_list = [console_ip, "csbs_console_cbsadmin_password"]
            console_host = check_data[console_ip]
            try:
                ssh_client = Ssh.ssh_create_client(console_host, CBS_ADMIN, cbsadmin_pwd)
                check_result.set_check_result(param_keys=check_list, status=200, error_msg='')
            except:
                logger.error("Failed to login to Console node: IP %s, User %s" % (console_host, CBS_ADMIN))
                check_result.set_check_result(param_keys=check_list, status=500, error_msg=code2Msg(642001))

            check_list = [console_ip, "csbs_console_root_password"]
            try:
                Ssh.ssh_send_command(ssh_client, 'sudo su', '[sudo] password for root:', 10)
                Ssh.ssh_send_command(ssh_client, root_pwd, '#', 10)
                check_result.set_check_result(param_keys=check_list, status=200, error_msg='')
            except:
                logger.error("Failed to login to Console node: IP %s, User %s" % (console_host, ROOT))
                check_result.set_check_result(param_keys=check_list, status=500, error_msg=code2Msg(642001))
            finally:
                try:
                    Ssh.ssh_close(ssh_client)
                except:
                    logger.error("Failed to close ssh client: IP %s" % console_host)

    # 校验karbor IP和密码，karbor 两节点部署或三节点部署
    djmanager_pwd_check_count = 0
    djmanager_pwd_no_ssh_ips = []
    karbor_root_pwd_check_count = 0
    karbor_root_no_ssh_ips = []
    djmanager_pwd = check_data["csbs_karbor_djmanager_password"]
    root_pwd = check_data["csbs_karbor_root_password"]
    check_list1 = ["csbs_karbor_djmanager_password"]
    check_list2 = ["csbs_karbor_root_password"]

    # 先检查2个节点
    for karbor_ip in ["karbor_host0", "karbor_host1"]:
        ssh_client = None
        karbor_host = vm_ips_dict[karbor_ip]
        try:
            ssh_client = Ssh.ssh_create_client(karbor_host, DJMANAGER, djmanager_pwd)
            djmanager_pwd_check_count += 1
        except:
            logger.error(traceback.format_exc())
            logger.error("Failed to login to Karbor node: IP %s, User %s" % (karbor_host, DJMANAGER))
            djmanager_pwd_no_ssh_ips.append(karbor_host)
        try:
            Ssh.ssh_send_command(ssh_client, 'su', 'Password:', 10)
            Ssh.ssh_send_command(ssh_client, root_pwd, '#', 10)
            karbor_root_pwd_check_count += 1
        except:
            logger.error(traceback.format_exc())
            logger.error("Failed to login to Karbor node: IP %s, User %s" % (karbor_host, ROOT))
            karbor_root_no_ssh_ips.append(karbor_host)
        finally:
            try:
                Ssh.ssh_close(ssh_client)
            except:
                logger.error("Failed to close ssh client: IP %s" % karbor_host)

    # 非高可用场景, 检查第三个节点
    if not is_csha_scene(project_id):
        karbor_ip = 'karbor_host2'
        ssh_client = None
        karbor_host = vm_ips_dict[karbor_ip]
        try:
            ssh_client = Ssh.ssh_create_client(karbor_host, DJMANAGER, djmanager_pwd)
            djmanager_pwd_check_count += 1
        except:
            logger.error("Failed to login to Karbor node: IP %s, User %s" % (karbor_host, DJMANAGER))
            djmanager_pwd_no_ssh_ips.append(karbor_host)
        try:
            Ssh.ssh_send_command(ssh_client, 'su', 'Password:', 10)
            Ssh.ssh_send_command(ssh_client, root_pwd, '#', 10)
            karbor_root_pwd_check_count += 1
        except:
            logger.error("Failed to login to Karbor node: IP %s, User %s" % (karbor_host, ROOT))
            karbor_root_no_ssh_ips.append(karbor_host)
        finally:
            try:
                Ssh.ssh_close(ssh_client)
            except:
                logger.error("Failed to close ssh client: IP %s" % karbor_host)

        if djmanager_pwd_check_count == 3:
            check_result.set_check_result(param_keys=check_list1, status=200, error_msg='')
        else:
            logger.error("Failed to login to "
                         "Karbor node: IP %s, User %s" % (','.join(djmanager_pwd_no_ssh_ips), DJMANAGER))
            check_result.set_check_result(param_keys=check_list1, status=500, error_msg=code2Msg(642001))

        if karbor_root_pwd_check_count == 3:
            check_result.set_check_result(param_keys=check_list2, status=200, error_msg='')
        else:
            logger.error("Failed to login to "
                         "Karbor node: IP %s, User %s" % (','.join(karbor_root_no_ssh_ips), ROOT))
            check_result.set_check_result(param_keys=check_list2, status=500, error_msg=code2Msg(642001))
    else:
        if djmanager_pwd_check_count == 2:
            check_result.set_check_result(param_keys=check_list1, status=200, error_msg='')
        else:
            logger.error("Failed to login to "
                         "Karbor node: IP %s, User %s" % (','.join(djmanager_pwd_no_ssh_ips), DJMANAGER))
            check_result.set_check_result(param_keys=check_list1, status=500, error_msg=code2Msg(642001))
        if karbor_root_pwd_check_count == 2:
            check_result.set_check_result(param_keys=check_list2, status=200, error_msg='')
        else:
            logger.error("Failed to login to "
                         "Karbor node: IP %s, User %s" % (','.join(karbor_root_no_ssh_ips), ROOT))
            check_result.set_check_result(param_keys=check_list2, status=500, error_msg=code2Msg(642001))

        # csha 检查第三方仲裁节点
        ssh_client = None
        check_list = ["Arbitration_arb_admin_username",
                      "Arbitration_arb_admin_password",
                      "Arbitration_Arbitration_DC3_IP"]
        try:
            ssh_client = Ssh.ssh_create_client(check_data["Arbitration_Arbitration_DC3_IP"],
                                               check_data["Arbitration_arb_admin_username"],
                                               check_data["Arbitration_arb_admin_password"])
            check_result.set_check_result(param_keys=check_list, status=200, error_msg='')
        except:
            logger.error("Failed to login to Arbitration node:"
                         "IP %s, User %s" % (check_data["Arbitration_Arbitration_DC3_IP"],
                                             check_data["Arbitration_arb_admin_username"]))
            check_result.set_check_result(param_keys=check_list, status=500,
                                          error_msg=code2Msg(642001))

        check_list = ["Arbitration_Arbitration_DC3_IP", "Arbitration_root_password"]
        try:
            Ssh.ssh_send_command(ssh_client, 'su', 'Password:', 10)
            Ssh.ssh_send_command(ssh_client, check_data["Arbitration_root_password"], '#', 10)
            check_result.set_check_result(param_keys=check_list, status=200, error_msg='')
        except:
            logger.error("Failed to login to Arbitration node:"
                         "IP %s, User %s" % (check_data["Arbitration_Arbitration_DC3_IP"], ROOT))
            check_result.set_check_result(param_keys=check_list, status=500, error_msg=code2Msg(642001))
        finally:
            try:
                Ssh.ssh_close(ssh_client)
            except:
                logger.error("Failed to close ssh client: IP %s" % check_data["Arbitration_Arbitration_DC3_IP"])

    return check_result
