import os

CONFIG_FILE_DIR = "{}/{}".format(os.path.dirname(os.path.realpath(__file__)),
                                 "../../config")


class ConfigFiles(object):
    def __init__(self, params_store, ex_params=None):
        self.upgrade_path = params_store.upgrade_path
        self.project_scene = params_store.project_scene
        self.config_dict = \
            params_store.db_params_dict if not ex_params else ex_params
        self.console_dmk_config_content = {}
        self.karbor_dmk_config_content = {}

    def get_console_config_files(self):
        if not self.console_dmk_config_content:
            self.init_console_config_file()
        return self.console_dmk_config_content

    def get_karbor_config_files(self):
        if not self.karbor_dmk_config_content:
            self.init_karbor_config_file()
        return self.karbor_dmk_config_content

    def get_config(self, db_dict, file_path):
        """Configuring the DMK Template File

        :param db_dict:The dict type, read from corresponding service
        in the database.Generally is __db_params_dict.
        :param file_path: DMK configuration file template path
        :return:Returns the character string that is automatically filled
        in the DMK configuration file by the dictionary.
        """
        config_str = self.get_config_content(file_path)
        return config_str.format(**db_dict)

    @staticmethod
    def get_config_content(file_path):
        """Reading the DMK Configuration Template

        :param file_path: DMK configuration file template path
        :return:Returns the character string of the DMK configuration file.
        """
        with open(file_path, encoding='utf-8') as f:
            config_str = f.read()
            return config_str

    def init_console_config_file(self):
        """Rendering the 'console upgrade config&host' files"""
        template_console_config = '{}/console_config'.format(CONFIG_FILE_DIR)
        template_console_host = '{}/console_host'.format(CONFIG_FILE_DIR)
        self.console_dmk_config_content['config'] = \
            self.get_config(self.config_dict, template_console_config)
        self.console_dmk_config_content['host'] = \
            self.get_config_content(template_console_host)

    def init_karbor_config_file(self):
        """Rendering the 'console upgrade config&host' files"""
        if self.project_scene.is_csha_scene:
            template_karbor_config = \
                '{}/csha_karbor_config'.format(CONFIG_FILE_DIR)
            template_karbor_host = \
                '{}/csha_karbor_host'.format(CONFIG_FILE_DIR)
        else:
            template_karbor_config = \
                '{}/karbor_config'.format(CONFIG_FILE_DIR)
            template_karbor_host = \
                '{}/karbor_host'.format(CONFIG_FILE_DIR)
        self.karbor_dmk_config_content['config'] = \
            self.get_config(self.config_dict, template_karbor_config)
        self.karbor_dmk_config_content['host'] = \
            self.get_config_content(template_karbor_host)
