import utils.common.log as logger
from utils.business.manageone_console_util import ManageOneConsoleUtil
from utils.business.manageone_util2 import ManageOneUtil2
from utils.common.exception import FCUException
from utils.common.ssh_util import Ssh

logger.init("CSBS-VBS")


class ConsoleUpgrade(object):
    def __init__(self, params_store):
        self.params_store = params_store
        self.project_scene = params_store.project_scene

    @staticmethod
    def upload_console_pkg(pod_id, console_file, region_flag=False):
        """upload console pkg to ManageOne-Tenant node

        """
        try:
            logger.info("Start upload console pkg.")
            sopuser_pwd = \
                ManageOneUtil2().get_sopuser_passwd(pod_id, region_flag)
            tenant_node_list = \
                ManageOneUtil2().get_tenant_ip_list(pod_id, region_flag)

            ssh_client = Ssh()
            for tenant_ip in tenant_node_list[1:]:
                logger.info("Begin upload console pkg "
                            "to {} tmp dir.".format(tenant_ip))
                ssh_client.put_file(tenant_ip, "sopuser", sopuser_pwd,
                                    console_file, "/tmp")
        except Exception as err:
            logger.error("Upload console pkg failed:{}.".format(err))
            return False
        logger.info("Upload console pkg "
                    "to {} success.".format(tenant_node_list))
        return True

    @staticmethod
    def upgrade_cbs_console(pod_id, console_pkg_name, region_flag,
                            region_id, pkg_version):
        """upgrade console to ManageOne CF2

        :return:
        """
        try:
            logger.info("Call MO API to upgrade CSBS-VBS console, package "
                        "is:{}, region id:{}.".format(console_pkg_name,
                                                      region_id))
            ManageOneConsoleUtil().update_console(
                pod_id=pod_id,
                service_type="cbs",
                file_name=console_pkg_name,
                primary_flag=region_flag,
                region=region_id,
                version=pkg_version
            )
            logger.info("Upgrade CSBS-VBS console successfully.")
        except FCUException as fe:
            logger.error("Upgrade console pkg failed, err:{}.".format(str(fe)))
            return False
        except Exception as e:
            logger.error("Upgrade console pkg failed, err:{}.".format(str(e)))
            return False
        return True

    @staticmethod
    def rollback_console_service(pod_id, region_flag, region_id, pkg_version):
        try:
            logger.info("Start rollback CSBS-VBS console.")
            ManageOneConsoleUtil().rollback_console(
                pod_id=pod_id,
                type="cbs",
                primary_flag=region_flag,
                region=region_id,
                version=pkg_version
            )
        except FCUException as fe:
            logger.error("Rollback console service failed, error:"
                         "{}.".format(str(fe)))
            return False
        except Exception as e:
            logger.error("Rollback console service failed, error:"
                         "{}.".format(str(e)))
            return False
        return True
