from utils.business.dmk_util import DmkApi
from utils.common import log as logger
from utils.common.exception import FCUException

logger.init("CSBS-VBS")


class DMKClient(object):
    def __init__(self, params_store):
        self.dmk_params = params_store.dmk_params
        self.karbor_params = params_store.karbor_params
        self.project_scene = params_store.project_scene
        self.dmk_api = DmkApi()

    def _login_dmk_by_cbs_account(self):
        self.dmk_api.login_dmk(self.dmk_params.float_ip,
                               self.dmk_params.account,
                               self.dmk_params.account_pwd)

    def execute_dmk_deploy(self, app_name, app_version, deploy_action,
                           hosts_content, vars_content, to_run="true",
                           user="djmanager"):
        self._login_dmk_by_cbs_account()
        account_id = \
            self.dmk_api.get_dmk_account_id(self.dmk_params.account, user)
        result = \
            self.dmk_api.excute_dmk_deployment(app_name=app_name,
                                               to_run=to_run,
                                               app_version=app_version,
                                               deploy_action=deploy_action,
                                               hosts_content=hosts_content,
                                               vars_content=vars_content,
                                               account_id=account_id)
        return result

    def upload_pkg_to_dmk_for_upgrade(self, pkg, pod_id):
        self._login_dmk_by_cbs_account()

        self.dmk_api.upload_pkg_to_dmk(
            self.dmk_params.float_ip,
            self.dmk_params.os_business_username,
            self.dmk_params.os_business_password,
            pkg,
            pod_id)

    def create_cbs_account_for_upgrade(self):
        # login by admin account and create new account
        self.dmk_api.login_dmk(self.dmk_params.float_ip,
                               self.dmk_params.ui_username,
                               self.dmk_params.ui_password,
                               dmk_port='8443')
        role = '2'
        user_info = self.dmk_api.create_dmk_user(
            self.dmk_params.account,
            self.dmk_params.tmp_account_pwd,
            role,
            self.dmk_params.account_group)
        user_id = user_info[1]
        team_id = user_info[0]

        # login by new account and change the original password
        self.dmk_api.login_dmk(self.dmk_params.float_ip,
                               self.dmk_params.account,
                               self.dmk_params.tmp_account_pwd)

        self.dmk_api.change_dmk_user_passwd(user_id,
                                            self.dmk_params.tmp_account_pwd,
                                            self.dmk_params.account_pwd)

        # login dmk by new password
        self._login_dmk_by_cbs_account()
        # delete dmk account before create account
        self._delete_dmk_account_by_account_name(
            self.dmk_params.account,
            self.karbor_params.djmanager_account_name)
        # create account for karbor djmanager
        self.dmk_api.add_account_to_dmk(
            self.karbor_params.djmanager_account_name,
            team_id,
            self.karbor_params.djmanager_account_pwd,
            self.karbor_params.root_account_pwd)

        # login by admin account, and update user to multi team,
        # so that ICAgent service can be deployed
        team_list = [self.dmk_params.account, 'OTD']
        self.dmk_api.login_dmk(self.dmk_params.float_ip,
                               self.dmk_params.ui_username,
                               self.dmk_params.ui_password)
        result_dmk = self.dmk_api.update_user_to_multi_team(user_id, 2,
                                                            team_list)
        if not result_dmk:
            logger.error("Failed to update user to multi_team for "
                         "CBS_UPGRADE.")
            raise FCUException("640004")
        logger.info("Succeed creating DMK Account.")

    def _delete_dmk_account_by_account_name(self, user_name, account_name):
        while True:
            try:
                account_id = self.dmk_api.get_dmk_account_id(user_name,
                                                             account_name)
                if account_id:
                    self.dmk_api.delete_dmk_account(account_id)
            except Exception as e:
                logger.warn("The {} account does not exist, "
                            "err_msg: {}.".format(account_name, str(e)))
                return
