import os
import shutil
import time
import zipfile

import utils.common.log as logger


def get_checkpoint_item_list(http_client, console_host, project_id,
                             product_type="ecs"):
    url_base = "https://{console_host}/cbs/rest/karbor/v1/" \
               "{project_id}/checkpoint_items"
    if product_type == "evs":
        url_base += "?resource_type=OS::Cinder::Volume"
    url = url_base.format(console_host=console_host, project_id=project_id)
    return http_client.get(url)


def get_checkpoint_item_detail(http_client, console_host,
                               project_id, checkpoint_item_id):
    url = "https://{console_host}/cbs/rest/karbor/v1/" \
          "{project_id}/checkpoint_items/{checkpoint_item_id}".format(
              console_host=console_host,
              project_id=project_id,
              checkpoint_item_id=checkpoint_item_id)
    return http_client.get(url)


def waiting_checkpoint_item_available(http_client,
                                      console_host,
                                      project_id,
                                      checkpoint_item_id):
    cur_checkpoint_item_status = ''
    count = 0
    while cur_checkpoint_item_status != 'available':
        _, checkpoint_item_info = get_checkpoint_item_detail(
            http_client,
            console_host,
            project_id,
            checkpoint_item_id)
        cur_checkpoint_item_status = checkpoint_item_info[
            "checkpoint_item"]["status"]
        if cur_checkpoint_item_status == "available":
            break

        if cur_checkpoint_item_status in ["protecting", "restoring",
                                          "copying"]:
            logger.info(
                "Current task progress value: {}.".format(
                    checkpoint_item_info["checkpoint_item"][
                        "extend_info"]["progress"]))
        logger.info(
            "Current copy's status:{}.".format(cur_checkpoint_item_status))

        if cur_checkpoint_item_status == "error":
            raise Exception(
                "Copy's status is error, task failed, please check.")

        count = count + 1
        if count > 200:
            raise Exception(
                "There may be some problem, 100 minutes passed.")
        time.sleep(30)

    logger.info("The checkpoint_item is available now.")

    return checkpoint_item_id


def unzip_file(file, target_path):
    zf = zipfile.ZipFile(file)
    max_size = 1 * 1024 * 1024 * 1024 * 10
    current_size = 0
    try:
        if os.path.exists(target_path):
            shutil.rmtree(target_path)
        os.mkdir(target_path)
        for info in zf.infolist():
            current_size += info.file_size
            if current_size >= max_size:
                raise Exception("The size of file to unzip exceeds "
                                "max size {} byte allowed".format(max_size))
            zf.extract(info.filename, path=target_path)
        logger.info("Unzip file {} to {} success.".format(file, target_path))
    except Exception as err:
        raise Exception('Unzip {} failed:{}.'.format(file, str(err)))
    finally:
        zf.close()
