import utils.common.log as logger
from platforms.param.param_check_handler import HandleParamCheck
from platforms.param.param_service import ParamService
from plugins.CSBS_VBS.common.upgrade.params import ParamsTools
from plugins.CSBS_VBS.common.upgrade.parmas_checker import ParamsChecker
from utils.common.code2Msg import code2Msg
from utils.common.ssh_util import Ssh

CBS_ADMIN = 'cbs_admin'
ROOT = 'root'


def params_check(project_id):
    check_result = HandleParamCheck()
    params_tools = ParamsTools(project_id)

    # check karbor related params, including ip, password
    params_checker = ParamsChecker(project_id)
    check_result = params_checker.check_karbor_login_ability(check_result)
    check_result = params_checker.check_arbitration_node(check_result)

    db_opt = ParamService()
    check_data = db_opt.get_need_check_cloud_params(project_id, 'CSBS-VBS')

    if params_tools.is_primary_region or params_tools.is_global_dr_scene:
        check_result = check_current_region_console_params(check_data,
                                                           check_result,
                                                           params_tools)
    return check_result


def check_current_region_console_params(check_data, check_result,
                                        params_tools):
    vm_ips_dict = params_tools.get_console_vm_ips()
    cbsadmin_pwd_check_count = 0
    cbsadmin_pwd_no_ssh_ips = []
    console_root_pwd_check_count = 0
    console_root_pwd_no_ssh_ips = []
    cbsadmin_pwd = check_data["csbs_console_cbsadmin_password"]
    root_pwd = check_data["csbs_console_root_password"]
    check_list1 = ["csbs_console_cbsadmin_password"]
    check_list2 = ["csbs_console_root_password"]
    for console_ip in vm_ips_dict.values():
        ssh_client = None
        try:
            ssh_client = Ssh.ssh_create_client(console_ip,
                                               CBS_ADMIN,
                                               cbsadmin_pwd)
            cbsadmin_pwd_check_count += 1
        except Exception as e:
            logger.error("Failed to login to Console node: IP {}, "
                         "User {}, msg_err:{}.".format(console_ip,
                                                       CBS_ADMIN,
                                                       str(e)))
            cbsadmin_pwd_no_ssh_ips.append(console_ip)

        try:
            Ssh.ssh_send_command(ssh_client, 'sudo su',
                                 '[sudo] password for root:', 10)
            Ssh.ssh_send_command(ssh_client, root_pwd, '#', 10)
            console_root_pwd_check_count += 1
        except Exception as e:
            logger.error("Failed to login to Console node: IP {}, "
                         "User {}, msg_err:{}.".format(console_ip,
                                                       ROOT,
                                                       str(e)))
            console_root_pwd_no_ssh_ips.append(console_ip)
        finally:
            try:
                Ssh.ssh_close(ssh_client)
            except Exception as e:
                logger.error("Failed to close ssh client:"
                             " IP {}, msg_err:{}.".format(console_ip,
                                                          str(e)))
    if cbsadmin_pwd_check_count == 2:
        check_result.set_check_result(param_keys=check_list1, status=200,
                                      error_msg='')
    else:
        logger.error("Failed to login to Console node: IP {}, "
                     "User {}.".format(','.join(cbsadmin_pwd_no_ssh_ips),
                                       CBS_ADMIN))
        check_result.set_check_result(param_keys=check_list1, status=500,
                                      error_msg=code2Msg(642001))
    if console_root_pwd_check_count == 2:
        check_result.set_check_result(param_keys=check_list2, status=200,
                                      error_msg='')
    else:
        logger.error("Failed to login to Console node: IP {}, User {}."
                     .format(','.join(console_root_pwd_no_ssh_ips), ROOT))
        check_result.set_check_result(param_keys=check_list2, status=500,
                                      error_msg=code2Msg(642001))
    return check_result
