import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import ConsoleSoloUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class CheckConsole(ConsoleSoloUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(CheckConsole, self).__init__(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            if not self.project_scene.is_primary_region \
                    and not self.project_scene.is_global_dr_scene:
                logger.info("SubRegion does not need to be checked.")
                return Message(200)

            result = self.check_console()
            if result:
                logger.info(
                    "Check current region Console service successfully.")
            else:
                return Message(500, FCUException(645013))
            return Message(200)
        except Exception as e:
            logger.error("Check Console service failed, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645013))
