import time

import utils.common.log as logger
from plugins.CSBS_VBS.common.ssh_client import SshClient
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class ConfigMOCerts(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(ConfigMOCerts, self).__init__(project_id, pod_id, regionid_list)
        self.ssh_client = SshClient()

    def execute(self, project_id, pod_id, regionid_list=None):
        """update certs of iam、sc and oc on karbor

        """
        logger.info("Start config karbor MO certs.")
        try:
            self._config_nodes_mo_certs()
            logger.info("Config the MO certs successfully.")
        except Exception as e:
            logger.error("Failed to config karbor MO certs, "
                         "error: {}.".format(str(e)))
            return Message(500, FCUException(645017))
        return Message(200)

    def _config_nodes_mo_certs(self):
        cbs_node0 = self.karbor_params.cbs_node0
        cbs_node1 = self.karbor_params.cbs_node1
        karbor_nodes = [cbs_node0, cbs_node1]
        retry_time_limit = 6
        sleep_seconds = 30
        for node in karbor_nodes:
            ssh_client = self.ssh_client.get_sshclient_user_su_root(node)
            retry_times = 0
            while retry_times < retry_time_limit:
                try:
                    if not self._config_mo_certs(ssh_client):
                        retry_times += 1
                        logger.error(
                            "Config mo certs failed on node:{}, sleep {}s, "
                            "retry times:{}.".format(node.ip,
                                                     sleep_seconds,
                                                     retry_times))
                        time.sleep(sleep_seconds)
                        continue
                    else:
                        logger.info("Succeed config mo certs on node:"
                                    "{}.".format(node.ip))
                        self.ssh_client.ssh_close(ssh_client)
                        break
                except Exception as e:
                    self.ssh_client.ssh_close(ssh_client)
                    raise Exception("Execute error:{}.".format(str(e)))
            if retry_times >= retry_time_limit:
                raise Exception("Config MO certs failed, after retry 6 times.")

    def _config_mo_certs(self, ssh_client):
        try:
            rm_cmd = "rm -f /home/djmanager/trust.cer_bak"
            mv_cmd = "mv /opt/huawei/dj/DJSecurity/server-ca/trust.cer " \
                     "/home/djmanager/trust.cer_bak"
            iam_cmd = "set_auth_endpoint " \
                      "--auth_ca_cert /home/djmanager/trust_apimlb_iam.cer"
            sc_cmd = "set_auth_endpoint " \
                     "--sc_ca_cert /home/djmanager/trust_apimlb_sc.cer"
            oc_cmd = "set_auth_endpoint " \
                     "--oc_ca_cert /home/djmanager/trust_apimlb_oc.cer"
            cmds = [rm_cmd, mv_cmd, iam_cmd, sc_cmd, oc_cmd]
            for cmd in cmds:
                result = \
                    self.ssh_client.ssh_exec_command_return(ssh_client, cmd)
                if not self.ssh_client.is_ssh_cmd_executed(result):
                    logger.error('Failed executing: {}.'.format(cmd))
                    return False
            return True
        except Exception as err:
            raise Exception('Config mo certs failed, Execute '
                            'error:{}.'.format(str(err)))
