import utils.common.log as logger
from plugins.CSBS_VBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class OffAutoBak(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(OffAutoBak, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        """turn auto backup off

        """
        logger.info("Start to turn off Karbor Automatic Backup.")

        try:
            self.karbor_operation.change_operation_service(tar_status="stop")
        except Exception as e:
            logger.error("Failed to turn off Karbor automatic backup, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645019))

        logger.info("Turn off automatic backup function succeed.")
        return Message(200)
