import utils.common.log as logger
from platforms.upgradecheck.check_result import CheckResult
from plugins.CSBS_VBS.job.upgrade.base import ConsoleSoloUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class PreCheckConsole(ConsoleSoloUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckConsole, self).__init__(project_id, pod_id,
                                              regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        """The console node service check

        """
        try:
            item_dict = self.params_store.get_check_config("PreCheckConsole")
            check_results = []
            if not self.project_scene.is_primary_region \
                    and not self.project_scene.is_global_dr_scene:
                logger.info("SubRegion does not need to be checked.")
                result = CheckResult(
                    itemname_ch=item_dict["itemname_ch"],
                    itemname_en=item_dict["itemname_en"],
                    status=item_dict["success_status"])
                check_results.append(result)
                return Message(200, check_results=check_results)

            result = self.check_console()
            if result:
                logger.info("Check Current Console service successfully.")
                result = \
                    CheckResult(
                        itemname_ch=item_dict["itemname_ch"],
                        itemname_en=item_dict["itemname_en"],
                        status=item_dict["success_status"])
            else:
                logger.error("Failed to check current console service.")
                result = \
                    CheckResult(
                        itemname_ch=item_dict["itemname_ch"],
                        itemname_en=item_dict["itemname_en"],
                        status=item_dict["failure_status"],
                        error_msg_cn=item_dict["error_msg_cn"],
                        error_msg_en=item_dict["error_msg_en"],
                        suggestion_cn=item_dict["suggestion_cn"],
                        suggestion_en=item_dict["suggestion_en"])
            check_results.append(result)

            return Message(200, check_results=check_results)
        except Exception as e:
            logger.error("Check console service failed, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645013))
