import utils.common.log as logger
from platforms.upgradecheck.check_result import CheckResult
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.business.project_util import ProjectApi
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class PreCheckVersion(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckVersion, self).__init__(project_id, pod_id,
                                              regionid_list)
        self.original_version = self.upgrade_path.original_version
        self.current_version = self.upgrade_path.current_version
        self.target_version = self.upgrade_path.target_version
        self.project_api = ProjectApi()

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            # check version before upgrade
            item_dict = self.params_store.get_check_config("PerCheckVersion")
            check_results = []
            if self.current_version in self.original_version:
                result = CheckResult(itemname_ch=item_dict["itemname_ch"],
                                     itemname_en=item_dict["itemname_en"],
                                     status=item_dict["success_status"])
                check_results.append(result)
            else:
                result = CheckResult(
                    itemname_ch=item_dict["itemname_ch"],
                    itemname_en=item_dict["itemname_en"],
                    status=item_dict["failure_status"],
                    error_msg_cn=item_dict["error_msg_cn"].format(
                        self.original_version,
                        str(self.current_version)),
                    error_msg_en=item_dict["error_msg_en"].format(
                        self.original_version,
                        str(self.current_version)),
                    suggestion_cn=item_dict["suggestion_cn"],
                    suggestion_en=item_dict["suggestion_en"])
                check_results.append(result)
                return Message(200, check_results=check_results)
            logger.info("Check Karbor version succeed.")

            # save pre-upgrade and post-upgrade versions
            version_info = {
                "Originalversion": self.original_version,
                "Targetversion": self.target_version
            }
            self.project_api.save_version_info(self.project_id,
                                               "CSBS-VBS",
                                               version_info)
            return Message(200, check_results=check_results)
        except Exception as e:
            logger.error("Check version failed, reason: {}.".format(str(e)))
            return Message(500, FCUException(645021))
