import utils.common.log as logger
from plugins.CSBS_VBS.common.upgrade.console_upgrade import ConsoleUpgrade
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.message import Message
from utils.common.exception import FCUException

logger.init("CSBS-VBS")


class RollbackConsole(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollbackConsole, self).__init__(project_id, pod_id,
                                              regionid_list)
        self.console_upgrade = ConsoleUpgrade(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            logger.info("Start rollback current region Console.")
            region_flag = False
            if not self.project_scene.is_primary_region:
                region_flag = True
            result = \
                self.console_upgrade.rollback_console_service(
                    pod_id=pod_id,
                    region_flag=region_flag,
                    region_id=regionid_list[0],
                    pkg_version=self.upgrade_path.console_pkg_version)
            if result:
                logger.info("Rollback  region console successfully.")
            else:
                logger.error("Failed to rollback region console.")
                return Message(500, FCUException(645014))
            return Message(200)

        except Exception as e:
            logger.error("Failed to rollback console, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645014))
