import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import ConsoleSoloUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class RollbackConsole(ConsoleSoloUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollbackConsole, self).__init__(project_id, pod_id,
                                              regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            # mo solo upgrade will be happened only in primary region or
            # global_dr_scene
            if not self.project_scene.is_primary_region and \
                    not self.project_scene.is_global_dr_scene:
                logger.info("SubRegion does not need to be upgraded.")
                return Message(200)

            self.backup_cert()

            result = self.rollback_console()

            if result:
                logger.info("Rollback current region Console successfully.")
            else:
                logger.error("Failed to rollback current region console.")
                return Message(500, FCUException(645014))

            self.replace_cert()
            return Message(200)
        except Exception as e:
            logger.error("Failed to rollback console, "
                         "reason: {}".format(str(e)))
            return Message(500, FCUException(645014))
