import time

import utils.common.log as logger
from plugins.CSBS_VBS.common.ssh_client import SshClient
from plugins.CSBS_VBS.job.upgrade.base import BaseSubJob
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")
RETRY_TIME_LIMIT = 6
SLEEP_SECONDS = 10


class RollbackMOCerts(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollbackMOCerts, self).__init__(project_id, pod_id,
                                              regionid_list)
        self.ssh_client = SshClient()

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Rollback iam, sc and oc certs on karbor nodes
        """
        logger.info("Start rollback Karbor iam certs.")
        cbs_node0 = self.karbor_params.cbs_node0
        ssh_client = self.ssh_client.get_sshclient_user_su_root(cbs_node0)
        retry_times = 0
        while retry_times < RETRY_TIME_LIMIT:
            try:
                if not self._rollback_iam_certs(ssh_client):
                    retry_times += 1
                    logger.error("Rollback iam certs failed, sleep {}s, "
                                 "retry times:{}.".format(SLEEP_SECONDS,
                                                          retry_times))
                    time.sleep(SLEEP_SECONDS)
                    continue
                self.ssh_client.ssh_close(ssh_client)
                logger.info("Succeed rollback iam certs "
                            "on node:{}.".format(cbs_node0.ip))
                return Message(200)
            except Exception as e:
                self.ssh_client.ssh_close(ssh_client)
                logger.error("Execute error:{}.".format(str(e)))
                return Message(500, FCUException(645024))
        self.ssh_client.ssh_close(ssh_client)
        logger.error("Rollback iam certs failed, after retry 6 times.")
        return Message(500, FCUException(645024))

    def _rollback_iam_certs(self, ssh_client):
        """Rollback iam certs config in karbor.

        :return:
        """
        try:
            iam_cmd = "set_auth_endpoint " \
                      "--auth_ca_cert /home/djmanager/trust.cer_bak"
            result = self.ssh_client.ssh_exec_command_return(ssh_client,
                                                             iam_cmd)
            if not self.ssh_client.is_ssh_cmd_executed(result):
                logger.error('Failed executing: {}.'.format(iam_cmd))
                return False
            return True
        except Exception as err:
            raise Exception(
                'Rollback iam certs failed, error: {}.'.format(err))
