import time

import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import KarborUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")
RETRY_TIME_LIMIT = 3


class StatusCheck(KarborUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(StatusCheck, self).__init__(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Check karbor service status after upgrade.

        """
        try:
            self.karbor_operation.change_operation_service(tar_status="start")

            logger.info("Login dmk and call DMK to check Karbor.")
            retry_times = 1
            while True:
                try:
                    result = self.check_karbor()
                    if result:
                        logger.info("Check Karbor service successfully.")
                        break
                except Exception as e:
                    logger.error("Karbor service status is abnormal, {}. "
                                 "Retry to check, retry times "
                                 "{}.".format(str(e), retry_times))
                    if retry_times > RETRY_TIME_LIMIT:
                        logger.info("No need to retry, retry times "
                                    "{}.".format(retry_times))
                        return Message(500, FCUException(645023))
                    retry_times += 1
                    time.sleep(10)

            # reset max sync time interval for gaussdb to be 10 minutes
            self.karbor_operation.set_max_sync_time_interval_allowed(10)

            # execute fix_architecture command on the first node with arm os
            if not self.project_scene.is_x86_scene:
                self.karbor_operation.reinforce_cut_over4arm()

            return Message(200)
        except Exception as e:
            logger.error("Failed to upgrade Karbor, reason:{}.".format(str(e)))
            return Message(500, FCUException(645023))
