import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import ConsoleSoloUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UpgradeConsole(ConsoleSoloUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UpgradeConsole, self).__init__(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            if not self.project_scene.is_primary_region and \
                    not self.project_scene.is_global_dr_scene:
                logger.info("SubRegion does not need to be upgraded.")
                return Message(200)

            self.backup_cert()

            result = self.upgrade_console()

            if result:
                logger.info("Upgrade Console successfully.")
            else:
                return Message(500, FCUException(645015))

            self.replace_cert()
            return Message(200)

        except Exception as e:
            logger.error("Failed to upgrade console, "
                         "reason: {}.".format(str(e)))
            return Message(500, FCUException(645015))
