import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import ConsoleSoloUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UploadConsolePkg(ConsoleSoloUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadConsolePkg, self).__init__(project_id, pod_id,
                                               regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            if not self.project_scene.is_primary_region and \
                    not self.project_scene.is_global_dr_scene:
                logger.info("SubRegion does not need to be upgraded.")
                return Message(200)

            logger.info(
                "Login dmk and call DMK to upload console upgrade pkg.")
            result = self.upload_console_pkg2vm()
            if result:
                logger.info(
                    "Upload current region console upgrade pkg to "
                    "Console VM successfully.")
            else:
                raise Exception("Failed to upload current region console "
                                "upgrade pkg to VM.")
            return Message(200)

        except Exception as ex:
            logger.error(ex)
            return Message(500, FCUException(645005))
