import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import KarborUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UploadKarborPkg(KarborUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadKarborPkg, self).__init__(project_id, pod_id,
                                              regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

             Upload Karbor upgrade package to karbor nodes
        """
        try:
            logger.info("Login dmk and call DMK to upload Karbor upgrade pkg.")
            result = self.upload_karbor_pkg2vm()
            if result:
                logger.info("Upload Karbor upgrade pkg to VM successfully.")
                return Message(200)
            else:
                return Message(500, FCUException(645005))
        except Exception as e:
            logger.error("Upload karbor package to Karbor nodes error, "
                         "err_msg: {}.".format(str(e)))
            return Message(500, FCUException(645005))
