import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import KarborUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UploadPkgToDMK(KarborUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(UploadPkgToDMK, self).__init__(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

          Upload Karbor upgrade package to DMK
        """
        if self.upgrade_path.target_version \
                != self.upgrade_path.karbor_pkg_version:
            raise Exception("The karbor package is not the expected one."
                            "Please check and upload karbor package "
                            "of the correct version.")

        logger.info("Starting to upload upgrade "
                    "packages:{}.".format(self.upgrade_path.karbor_pkg_name))
        try:
            self.upload_karbor_pkg2dmk()
        except Exception as ex:
            logger.error(ex)
            return Message(500, FCUException(645004))
        logger.info("Upload Karbor upgrade package to DMK successfully.")
        return Message(200)
