import utils.common.log as logger
from plugins.CSBS_VBS.job.upgrade.base import ConsoleSoloUpgradeSubJobBase
from utils.common.exception import FCUException
from utils.common.message import Message

logger.init("CSBS-VBS")


class UploadPkgToDMK(ConsoleSoloUpgradeSubJobBase):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadPkgToDMK, self).__init__(project_id, pod_id, regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Upload Console upgrade package to DMK

        """
        if not self.project_scene.is_primary_region and \
                not self.project_scene.is_global_dr_scene:
            logger.info("SubRegion does not need to be upgraded.")
            return Message(200)
        logger.info("Starting to upload Console upgrade packages, "
                    "pkg name: {}.".format(self.upgrade_path.console_pkg_name))
        try:
            self.upload_console_pkg2dmk()
        except Exception as ex:
            logger.error(ex)
            return Message(500, FCUException(645004))
        logger.info("Upload Console upgrade package to DMK successfully.")

        return Message(200)
