# -*- coding: utf-8 -*-
from utils.common.exception import FCUException
from platforms.param.param_check_handler import HandleParamCheck
from platforms.param.param_service import ParamService
from plugins.eBackup.common.params_check_tool import enable_other_params
from plugins.eBackup.common.params_check_tool import init_params
from plugins.eBackup.common.params_check_tool import check_web_login
from plugins.eBackup.common.params_check_tool import check_ebackup_nodes
from plugins.eBackup.common.params_check_tool import is_in_same_cluster
from plugins.eBackup.common.params_check_tool import check_ebackup_role
from plugins.eBackup.common.params_check_tool import check_connectivity
from plugins.eBackup.common.params_check_tool import check_iam_identify
from plugins.eBackup.common.params_check_tool import check_openstack_params
from plugins.eBackup.common.params_check_tool import Utils


def params_check(project_id):
    """插件参数校验接口函数

    错误信息返回值（需要中英文信息）：
    1、支持通过FCUException(error_code, *arg, **kwargs)类获取中英文信息,
    此方法是获取公共方法中的错误
    2、支持通过code2Msg(error_code, *arg, **kwargs)函数获取中英文信息,
    此方法是获取各组件自定义的错误
    """

    db_opt = ParamService()
    check_data = db_opt.get_need_check_cloud_params(project_id, "eBackup")
    check_result = HandleParamCheck()
    all_params = ["openstack_cps_web_pwd", "openstack_cps_admin_pwd",
                  "eBackup_Workflow_nodes", "eBackup_Datamover_nodes",
                  "eBackup_hcp_pwd", "eBackup_root_pwd",
                  "ManageOne_oc_external_global_domain_name",
                  "DMK_g_current_region:apicom.service",
                  "eBackup_iam_username", "eBackup_iam_pwd",
                  "eBackup_admin_pwd", "ManageOne_global_domain_name",
                  "eBackup_dmk_user", "eBackup_dmk_password"]
    init_params(check_data, db_opt, project_id, check_result, all_params)
    check_access_status(check_result, project_id, check_data)
    hcp_password = check_data.get("eBackup_hcp_pwd")
    root_password = check_data.get("eBackup_root_pwd")
    admin_password = check_data.get("eBackup_admin_pwd")
    workflow_hosts = check_data.get("eBackup_Workflow_nodes").split(";")
    iam_password = check_data.get("eBackup_iam_pwd")
    iam_user = check_data.get("eBackup_iam_username")
    # check iam user and pwd
    check_iam_identify(check_result, workflow_hosts, hcp_password,
                       root_password, iam_user, iam_password, admin_password)
    # check workflow web login
    result = check_workflow_web_log(
        check_result, workflow_hosts, hcp_password, root_password,
        admin_password, check_data, all_params)
    return result


def check_access_status(check_result, project_id, check_data):
    unpassed_ebackup_hcp_nodes = []
    unpassed_ebackup_root_nodes = []
    unpassed_openstack_fsp_nodes = []
    unpassed_openstack_root_nodes = []

    check_ebackup_nodes(
        check_result, "eBackup_Datamover_nodes",
        check_data.get("eBackup_Datamover_nodes"),
        check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"),
        unpassed_ebackup_hcp_nodes, unpassed_ebackup_root_nodes)
    check_ebackup_nodes(
        check_result, "eBackup_Workflow_nodes",
        check_data.get("eBackup_Workflow_nodes"),
        check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"),
        unpassed_ebackup_hcp_nodes, unpassed_ebackup_root_nodes)
    if 0 == len(unpassed_ebackup_hcp_nodes):
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"],
                                      status=200, error_msg="")
    else:
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"],
                                      status=500,
                                      error_msg=FCUException(650001, ",".join(
                                          unpassed_ebackup_hcp_nodes)))

    if 0 == len(unpassed_ebackup_root_nodes):
        check_result.set_check_result(param_keys=["eBackup_root_pwd"],
                                      status=200, error_msg="")
    else:
        check_result.set_check_result(param_keys=["eBackup_root_pwd"],
                                      status=500,
                                      error_msg=FCUException(650002, ",".join(
                                          unpassed_ebackup_root_nodes)))
    check_openstack_params(check_result, project_id, check_data,
                           unpassed_openstack_fsp_nodes,
                           unpassed_openstack_root_nodes)
    if 0 != len(unpassed_openstack_fsp_nodes):
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"],
                                      status=500,
                                      error_msg=FCUException(650005, ",".join(
                                          unpassed_openstack_fsp_nodes)))
    if 0 != len(unpassed_openstack_root_nodes):
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"],
                                      status=500,
                                      error_msg=FCUException(650006, ",".join(
                                          unpassed_openstack_root_nodes)))


def start_check(check_data, check_result, hcp_password,
                root_password, admin_password):
    for datamover_groups in \
            check_data.get("eBackup_Datamover_nodes").split("|"):
        datamover_hosts = datamover_groups.split(";")
        is_true = check_web_login(check_result, datamover_hosts,
                                  hcp_password, root_password,
                                  admin_password, 1)
        if is_true:
            b_result = is_in_same_cluster(check_result,
                                          'eBackup_Datamover_nodes',
                                          datamover_hosts, hcp_password,
                                          root_password, admin_password, 1)
            if b_result:
                b_result = check_ebackup_role(check_result,
                                              'eBackup_Datamover_nodes',
                                              datamover_hosts,
                                              hcp_password, root_password)
                if not b_result:
                    break
            else:
                break
        else:
            break


def check_manager_one(check_data, check_result, workflow_hosts, hcp_password,
                      root_password):

    key = "ManageOne_oc_external_global_domain_name"
    oc_external_domain_name = check_data.get(key)
    if oc_external_domain_name is not None and \
            len(oc_external_domain_name) != 0 and \
            Utils.check_ip_version(oc_external_domain_name) == -1:
        oc_domain_name = "oc." + oc_external_domain_name
        check_connectivity(check_result, [workflow_hosts[0]], hcp_password,
                           root_password, oc_domain_name, key)

    key = "ManageOne_global_domain_name"
    if -1 != Utils.check_ip_version(check_data.get(key)):
        silvan_domain_name = check_data.get(key)
    else:
        silvan_domain_name = "console-silvan." + check_data.get(key)
    is_true = check_connectivity(check_result, [workflow_hosts[0]],
                                 hcp_password, root_password,
                                 silvan_domain_name, key)
    if is_true:
        check_connectivity(check_result,
                           check_data.get("eBackup_Datamover_nodes").
                           replace('|', ';').split(';'),
                           hcp_password,
                           root_password, silvan_domain_name, key)


def check_workflow_web_log(
    check_result, workflow_hosts, hcp_password, root_password,
        admin_password, check_data, all_params):
    is_true = check_web_login(check_result, workflow_hosts, hcp_password,
                              root_password, admin_password, 2)
    if is_true:
        b_result = is_in_same_cluster(check_result, 'eBackup_Workflow_nodes',
                                      workflow_hosts, hcp_password,
                                      root_password, admin_password, 2)
        if b_result:
            check_ebackup_role(check_result, 'eBackup_Workflow_nodes',
                               workflow_hosts, hcp_password, root_password)
        start_check(check_data, check_result, hcp_password,
                    root_password, admin_password)
    # check ManageOne_oc_external_global_domain_name
    check_manager_one(check_data, check_result, workflow_hosts, hcp_password,
                      root_password)
    enable_other_params(check_result, all_params)
    return check_result
