# -*- coding: utf-8 -*-
from utils.common.exception import FCUException
from plugins.eBackup.common.params_check_tool import init_params
from platforms.param.param_check_handler import HandleParamCheck
from platforms.param.param_service import ParamService
from plugins.eBackup.common.params_check_tool import check_ebackup_nodes
from plugins.eBackup.common.params_check_tool import check_workflow_web_log
from plugins.eBackup.common.params_check_tool import check_openstack_params


def params_check(project_id):
    """插件参数校验接口函数

    错误信息返回值（需要中英文信息）：
    1、支持通过FCUException(error_code, *arg, **kwargs)类获取中英文信息,此方法是获取公共方法中的错误
    2、支持通过code2Msg(error_code, *arg, **kwargs)函数获取中英文信息,此方法是获取各组件自定义的错误
    """
    db_opt = ParamService()
    check_data = db_opt.get_need_check_cloud_params(project_id, "eBackup")
    check_result = HandleParamCheck()
    all_params = ["openstack_cps_web_pwd", "openstack_cps_admin_pwd",
                  "eBackup_Workflow_nodes", "eBackup_Datamover_nodes",
                  "eBackup_hcp_pwd",
                  "eBackup_root_pwd", "eBackup_admin_pwd", "eBackup_dmk_user",
                  "eBackup_dmk_password"]
    init_params(check_data, db_opt, project_id, check_result, all_params)
    unpassed_ebackup_hcp_nodes = []
    unpassed_ebackup_root_nodes = []
    unpassed_openstack_fsp_nodes = []
    unpassed_openstack_root_nodes = []
    fsp_expire_msg = {}
    hcp_expire_msg = {}
    root_lock_msg = {}
    check_ebackup_nodes(
        check_result, "eBackup_Datamover_nodes",
        check_data.get("eBackup_Datamover_nodes"),
        check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"),
        unpassed_ebackup_hcp_nodes, unpassed_ebackup_root_nodes,
        hcp_expire_msg, root_lock_msg)
    check_ebackup_nodes(
        check_result, "eBackup_Workflow_nodes",
        check_data.get("eBackup_Workflow_nodes"),
        check_data.get("eBackup_hcp_pwd"), check_data.get("eBackup_root_pwd"),
        unpassed_ebackup_hcp_nodes, unpassed_ebackup_root_nodes,
        hcp_expire_msg, root_lock_msg)
    param_check_judge(check_result, unpassed_ebackup_hcp_nodes, hcp_expire_msg,
                      root_lock_msg, unpassed_ebackup_root_nodes)
    check_openstack_params(
        check_result, project_id, check_data, unpassed_openstack_fsp_nodes,
        unpassed_openstack_root_nodes, fsp_expire_msg)
    ebackup_check_openstack_param(
        check_result, unpassed_openstack_fsp_nodes, fsp_expire_msg,
        unpassed_ebackup_hcp_nodes, unpassed_openstack_root_nodes)
    # check workflow web login
    result = check_workflow_web_log(check_data, check_result, all_params)
    return result


def param_check_judge(check_result, unpassed_ebackup_hcp_nodes, hcp_expire_msg,
                      root_lock_msg, unpassed_ebackup_root_nodes):
    if 0 != len(unpassed_ebackup_hcp_nodes) and 0 != len(hcp_expire_msg):
        result = FCUException(650038, ",".join(unpassed_ebackup_hcp_nodes),
                              'hcp',
                              ','.join(list(hcp_expire_msg.keys())), 'hcp',
                              str(hcp_expire_msg))
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"],
                                      status=500, error_msg=result)
    elif 0 != len(hcp_expire_msg):
        check_result.set_check_result(
            param_keys=["eBackup_hcp_pwd"],
            status=500,
            error_msg=FCUException(650037,
                                   ','.join(list(hcp_expire_msg.keys())),
                                   "hcp", str(hcp_expire_msg)))
    elif 0 != len(unpassed_ebackup_hcp_nodes):
        check_result.set_check_result(param_keys=["eBackup_hcp_pwd"],
                                      status=500,
                                      error_msg=FCUException(650001, ",".join(
                                          unpassed_ebackup_hcp_nodes)))
    elif 0 != len(root_lock_msg):
        check_result.set_check_result(
            param_keys=["eBackup_root_pwd"],
            status=500,
            error_msg=FCUException(650042,
                                   ','.join(list(root_lock_msg.keys())),
                                   "root", str(root_lock_msg)))
    elif 0 == len(unpassed_ebackup_root_nodes):
        check_result.set_check_result(param_keys=["eBackup_root_pwd"],
                                      status=200, error_msg="")
    else:
        check_result.set_check_result(param_keys=["eBackup_root_pwd"],
                                      status=500,
                                      error_msg=FCUException(650002, ",".join(
                                          unpassed_ebackup_root_nodes)))


def ebackup_check_openstack_param(check_result,
                                  unpassed_openstack_fsp_nodes,
                                  fsp_expire_msg,
                                  unpassed_ebackup_hcp_nodes,
                                  unpassed_openstack_root_nodes):
    if 0 != len(unpassed_openstack_fsp_nodes) and 0 != len(fsp_expire_msg):
        result = FCUException(650038, ",".join(unpassed_ebackup_hcp_nodes),
                              'fsp',
                              ','.join(list(fsp_expire_msg.keys())), 'fsp',
                              str(fsp_expire_msg))
        check_result.set_check_result(param_keys=["openstack_cps_admin_pwd"],
                                      status=500, error_msg=result)
    elif 0 != len(fsp_expire_msg):
        check_result.set_check_result(
            param_keys=["openstack_cps_admin_pwd"], status=500,
            error_msg=FCUException(
                650037, ','.join(list(fsp_expire_msg.keys())), "fsp",
                str(fsp_expire_msg)))
    elif 0 != len(unpassed_openstack_fsp_nodes):
        check_result.set_check_result(
            param_keys=["openstack_cps_admin_pwd"], status=500,
            error_msg=FCUException(
                650005, ",".join(unpassed_openstack_fsp_nodes)))

    if 0 != len(unpassed_openstack_root_nodes):
        check_result.set_check_result(
            param_keys=["openstack_cps_admin_pwd"], status=500,
            error_msg=FCUException(
                650006, ",".join(unpassed_openstack_root_nodes)))
