# -*- coding:utf-8 -*-
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from utils.business.dmk_util import DmkApi
from utils.business.param_util import ParamUtil
from plugins.eBackup.common.util import Utils


class CreateDmkAccount(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(CreateDmkAccount, self).__init__(self, project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.__dmk_util = DmkApi()
        self.util = ParamUtil()
        self.__db_param_dict = Utils.init_system_params(project_id,
                                                        regionid_list[0])
        self.manager_user = self.__db_param_dict['eBackup_dmk_user']
        self.manager_password = self.__db_param_dict['eBackup_dmk_password']
        self.user_tmp_pwd = self.__db_param_dict['eBackup_dmk_tmp_password']
        self.manager_group_name = "eBackup"
        self.fsp_user = "fsp"
        self.fsp_passwd = self.__db_param_dict['openstack_fsp_pwd']
        self.fsp_sudo_password = self.__db_param_dict['openstack_root_pwd']
        self.hcp_user = "hcp"
        self.hcp_user_pwd = self.__db_param_dict['eBackup_hcp_pwd']
        self.sudo_root_password = self.__db_param_dict['eBackup_root_pwd']

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._create_dmk_user()
            return Message(200)
        except FCUException as e:
            return Message(500, e)
        except Exception as e:
            logger.error("Failed to create DMK account for eBackup "
                         "plugin,the reason is %s" % e)
            return Message(500, FCUException(650008, str(e)))

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        pass

    def _create_dmk_user(self):
        self.__dmk_util.login_dmk(self.__db_param_dict['dmk_floatIp'],
                                  self.manager_user, self.manager_password)
        team_id = self.__dmk_util.get_dmk_team_id("eBackup")
        try:
            account_id = self.__dmk_util.get_dmk_account_id(self.manager_user,
                                                            self.fsp_user)
            if account_id:
                logger.info("Query account(%s) successfully,Now begin to "
                            "delete it." % self.fsp_user)
                self.__dmk_util.delete_dmk_account(account_id)
                logger.info("Delete account(%s) success,it will be "
                            "create again." % self.fsp_user)
        except Exception as e:
            logger.info("Query account(%s) failed, the reason %s" %
                        (self.fsp_user, str(e)))
            logger.info("It will create account(%s) later." % self.fsp_user)
        ret = self.__dmk_util.add_account_to_dmk(self.fsp_user, team_id,
                                                 self.fsp_passwd,
                                                 self.fsp_sudo_password)
        if not ret:
            logger.error("Create fsp account to multi team failed.")
            raise FCUException(650015, self.__db_param_dict['dmk_floatIp'],
                               self.fsp_user)

        try:
            account_id = self.__dmk_util.get_dmk_account_id(self.manager_user,
                                                            self.hcp_user)
            if account_id:
                logger.info("Query account(%s) successfully,Now begin "
                            "to delete it." % self.hcp_user)
                self.__dmk_util.delete_dmk_account(account_id)
                logger.info("Delete account(%s) success,it will be"
                            " create again." % self.hcp_user)
        except Exception as e:
            logger.info("Query account(%s) failed, the reason %s" %
                        (self.hcp_user, str(e)))
            logger.info("It will create account(%s) later." % self.hcp_user)
        ret = self.__dmk_util.add_account_to_dmk(self.hcp_user, team_id,
                                                 self.hcp_user_pwd,
                                                 self.sudo_root_password)
        if not ret:
            logger.error("Create hcp account to multi team failed.")
            raise FCUException(650015, self.__db_param_dict['dmk_floatIp'],
                               self.hcp_user)
