# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.dmk_util import DmkApi


class DMKTask(object):
    def __init__(self, dmk_float_ip, user, password):
        self.ip = dmk_float_ip
        self.login_user = user
        self.login_pwd = password
        self.dmk = DmkApi()

    def do_task(self, version, action, host, config,
                account, application='eBackup_Upgrade'):
        try:
            account_id = self._get_accounts(account)
            result = self.dmk.excute_dmk_deployment(app_name=application,
                                                    to_run="true",
                                                    app_version=version,
                                                    deploy_action=action,
                                                    hosts_content=host,
                                                    vars_content=config,
                                                    account_id=account_id)
            return result
        except Exception as ex:
            logger.error("Do Dmk task failed.The reason is %s" % str(ex))
            return False

    def _get_accounts(self, operation_user):
        self.dmk.login_dmk(self.ip, self.login_user, self.login_pwd)
        return self.dmk.get_dmk_account_id(self.login_user, operation_user)
