#!/usr/bin/python3
# -*- coding: UTF-8 -*-
from __future__ import print_function
import argparse
import re

def write_conf_file(nvme_driver_type):
    nvme_driver_type_arr = [0, 1]
    file_path = "/etc/nvme/snsd.conf"
    file_data = ""
    driver_type_tag = "--driver_type = "

    if int(nvme_driver_type) not in nvme_driver_type_arr:
        print("error, please input valid type.")
        exit(1)

    driver_type_str = driver_type_tag + nvme_driver_type

    with open(file_path, "r", encoding = "utf-8") as f:
        content = re.sub(rf'{driver_type_tag}\d+', f'{driver_type_tag}{nvme_driver_type}', f.read())

    with open(file_path, "w",encoding = "utf-8") as f:
        f.write(content)

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('nvme_driver_type')
    args = parser.parse_args()

    write_conf_file(args.nvme_driver_type)

    exit(0)