# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
管理存储812SPH105之前版本升级至813SPC100版本，升级前需要进行规避操作
"""
import traceback
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.check_result import CheckResult
from plugins.DistributedStorage.common.parameter_gain import ParamsGain
from plugins.DistributedStorage.Upgrade.scripts.impl.tc_upgrade_evade import UpgradeEvadeIntf


class UpgradeEvade(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(UpgradeEvade, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list).get_args(suit_id)
        self.upgrade_evade = UpgradeEvadeIntf(project_id, pod_id, self.fs_args)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        check_results = []
        try:
            self.upgrade_evade.procedure()
        except HCCIException as err:
            logger.error(traceback.format_exc())
            check_item = CheckResult(
                itemname_ch="分布式存储升级前预检查失败",
                itemname_en="DistributedStorage pre upgrade check failed",
                status="failure",
                error_msg_cn=err)
            check_results.append(check_item)
        except Exception as err:
            logger.error(traceback.format_exc())
            check_item = CheckResult(
                itemname_ch="分布式存储升级前预检查失败",
                itemname_en="DistributedStorage pre upgrade check failed",
                status="failure",
                error_msg_cn=HCCIException(621021, str(err)))
            check_results.append(check_item)
        else:
            check_item = CheckResult(
                itemname_ch="分布式存储升级前预检查成功",
                itemname_en="DistributedStorage pre upgrade check success",
                status="success")
            check_results.append(check_item)
        return Message(200, check_results=check_results)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
