# coding=utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import os
import stat
import pathlib
import shutil


from utils.common import log as logger


class FileHandle:
    @classmethod
    def create_tmp_dir(cls, path, permission=0o750):
        logger.info('Creating a directory:{}'.format(path))
        my_path = pathlib.Path(path)
        if my_path.is_dir():
            shutil.rmtree(str(my_path))
        my_path.mkdir(parents=True)
        my_path.chmod(permission)

    @classmethod
    def dump_content(cls, dst_path, content, permission=0o644):
        flags = os.O_CREAT | os.O_RDWR | os.O_EXCL
        mode = stat.S_IRUSR | stat.S_IWUSR
        with os.fdopen(os.open(dst_path, flags, mode), "wb") as file:
            file.write(content)
        pathlib.Path(dst_path).chmod(permission)
