# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.scripts.ManageConverge.implement.tc_create_cluster import CreateCluster


class CreateClusterIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args("master")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建控制集群，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        return CreateCluster(project_id, pod_id, self.fs_args).run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return CreateCluster(project_id, pod_id, self.fs_args).rollback()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        CreateCluster(project_id, pod_id, self.fs_args).clean_master_cluster()
        return CreateCluster(project_id, pod_id, self.fs_args).run()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
