/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;

public final class Util {
    private static final Util INSTANCE = new Util();
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String JAR_FULL_PATH = System.getProperty("java.class.path");
    private static final String JAR_DIR = new File(JAR_FULL_PATH).getParent();
    private static final String LOG_FILE = JAR_DIR + File.separator + ".." + File.separator + "logs" + File.separator + "create_cert.log";

    public static Util getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<X509Certificate> readCertBuf(byte[] byArray) throws GeneralSecurityException, IOException {
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(byteArrayInputStream);
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    Optional<X509Certificate> optional = Optional.of(x509Certificate);
                    return optional;
                }
                Optional<X509Certificate> optional = Optional.empty();
                return optional;
            }
            finally {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {
                    this.logToFile("Close byte array failed.");
                }
            }
        }
        throw new IOException("Certificate data is empty.");
    }

    public void logToFile(String string) {
        File file = new File(LOG_FILE);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, true);
             PrintWriter printWriter = new PrintWriter(fileOutputStream);){
            printWriter.append(FORMAT.format(new Date())).append(" ").append(string).append(System.lineSeparator());
            printWriter.flush();
        }
        catch (IOException iOException) {
            return;
        }
    }
}

