#!/bin/sh
########################################################################################
# 组件:restConvert
# 支持时间过滤日志
########################################################################################

Rest_LOG_PATH=/var/log/restconvert
Rest_LOG_FILE=${Rest_LOG_PATH}/scriptLog/collectLog.log

LOG_RST_PATH=/opt/dfv/oam/public/result/collect_log/FusionStorage_oam-u/restConvert/

REST_LOG_RUN_PATH=/var/log/restconvert/run

REST_LOG_SCRIPT_PATH=/var/log/restconvert/scriptLog

BEGIN_TIME=""
END_TIME=""

[ ! -d "${LOG_RST_PATH}" ] && mkdir -p ${LOG_RST_PATH}

mkdir -p ${LOG_RST_PATH}/scriptLog

mkdir -p ${LOG_RST_PATH}/run


function LOG()
{
    dir=$(basename ${0})
    su - rest -s "/bin/bash" -c "echo \"[`date \"+%Y-%m-%d %H:%M:%S\"`][$1][${dir}:$2] ${@:3}\" >> ${Rest_LOG_FILE}"
}

shopt -s expand_aliases
alias log_error='LOG ERROR $LINENO'
alias log_info='LOG INFO $LINENO'
alias log_warn='LOG WARN $LINENO'
alias log_debug='LOG DEBUG $LINENO'


function get_params()
{
    su - rest -s "/bin/bash" -c "echo \"`date` input param $1\" >> \"${Rest_LOG_FILE}\""
    for param in `echo $1 | sed -s "s/##/ /g"`
    do
        echo ${param} | grep "begin_time=" >>/dev/null
        if [ $? -eq 0 ]; then
            BEGIN_TIME=`echo ${param} | awk -F "=" '{print $2}'`
        fi
        echo ${param} | grep "end_time=" >>/dev/null
        if [ $? -eq 0 ]; then
            END_TIME=`echo ${param} | awk -F "=" '{print $2}'`
        fi
        log_info "coll ${BEGIN_TIME}-${END_TIME}"
    done
}


function collect_log_file()
{
    if [ ! -d ${Rest_LOG_PATH} ]; then
        return 1
    fi
    log_files=$(find ${REST_LOG_RUN_PATH} -regex ".*\.zip\|.*\.log" | sort | awk '{print $1}')
    for log_file in ${log_files};do
        file_name=`basename ${log_file}`
        if [[ ${file_name} == "rest.log" ]];then
            log_time=`date '+%s'`
        else
            log_time_1=`echo ${file_name} | awk '{split("'${file_name}'", array, ".");print array[2]}'`
            log_time_2=`echo ${file_name} | awk '{split("'${log_time_1}'", array, "_");print array[1]" "array[2]}'`
            log_time=`date -d "${log_time_2}" +%s`
        fi
        isCollect=0
        if [[ ${BEGIN_TIME} == "" || ${log_time} -ge "${BEGIN_TIME}" ]];then
            if [[  ${END_TIME} == "" || ${log_time} -le "${END_TIME}" ]]; then
                isCollect=1
            fi
        fi
        log_info "file_name ${file_name} log_time ${log_time} isCollect ${isCollect}"
        if [[ "${isCollect}" == "1" ]];then
            cp -P --remove-destination ${log_file} $1
        fi
    done
    cp -rP --remove-destination ${REST_LOG_SCRIPT_PATH}/* ${LOG_RST_PATH}/scriptLog
    return 0
}


function valid_params()
{
    log_info "param size $#"
    if [ $# -ge 2 ];then
        log_info "too much parameters size $#"
        return 1
    fi
    if [ $# -eq 1 ]; then
        regex_str_1="^begin_time=[0-9]+##end_time=[0-9]+$"
        regex_str_2="^begin_time=[0-9]+$"
        regex_str_3="^end_time=[0-9]+$"
        if [[ ! $1 =~ ${regex_str_1} && ! $1 =~ ${regex_str_2} && ! $1 =~ ${regex_str_3} ]]; then
            return 1
        fi
    fi
    return 0

}


function main()
{
    valid_params $@
    result=$?
    log_info "valid_params result ${result}"
    if [ $result -ne 0 ]; then
        return 1
    fi
    get_params $1
    if [[ ${BEGIN_TIME} == "" && ${END_TIME} == "" ]]; then
        # 开始结束都是空，收集全部
        cp -rP --remove-destination ${Rest_LOG_PATH}/run/* ${LOG_RST_PATH}/run
        cp -rP --remove-destination ${Rest_LOG_PATH}/scriptLog/* ${LOG_RST_PATH}/scriptLog
    else
        # 开始时间和结束时间都不为空，收集开始和结束时间之间的日志
        collect_log_file ${LOG_RST_PATH}/run
        if [ $? -ne 0 ]; then
            return 1
        fi
    fi
    return 0
}


log_info "begin to collect rest log"
main $@
if [ $? -ne 0 ]; then
    log_info "collect rest log failed"
else
    log_info "collect rest log ok"
fi
exit 0
