#!/bin/bash

CUR_DIR=$(dirname $(readlink -f $0))
source ${CUR_DIR}/bin/commonUtil.sh

LOG_NAME="uninstall.log"
RESTCONVERT_SCRIPT_LOG_PATH="/var/log/restconvert/scriptLog"
LOG_FILE="${RESTCONVERT_SCRIPT_LOG_PATH}/${LOG_NAME}"

initLog "${RESTCONVERT_SCRIPT_LOG_PATH}" "${LOG_NAME}"

STOP_SCRIPT_PATH="/opt/dfv/oam/rest/RestConvert/bin/stopRestConvert.sh"
CLI_PATH=/opt/dfv/oam/rest/RestConvert/config/cli
#0代表正常卸载场景，1代表升级场景
upgrade_flag=0

function main()
{
  log_info "begin to uninstall RestConvert"
  unRegisterHAPlugin
  if [ $? -ne 0 ];then
      print_error "unregister HA failed"
      return 1
  fi
  stopRestProcess
  if [ $? -ne 0 ];then
      print_error "stop rest process failed"
      return 1
  fi
  deleteRestLogMonitorFromCrontab
  if [ $? -ne 0 ];then
      print_error "delete crontab task failed"
      return 1
  fi
  unInstallRestCLI
  if [ $? -ne 0 ];then
      print_error "uninstall rest cli failed"
      return 1
  fi
  uninstallProcessFile
  if [ $? -ne 0 ];then
      echo "remove process file failed"
      return 1
  fi
  delRestUser
  if [ $? -ne 0 ];then
      echo "delete rest user failed"
      return 1
  fi
  delRestPortFireWall
  return 0
}

#卸载时候需要删除8999端口的防火墙
function delRestPortFireWall()
{
  isExist=$(iptables-save | grep 8999 | grep tcp | grep ACCEPT)
  if [ "${isExist}X" != "X" ];then
    iptables -D INPUT -p tcp -m tcp --dport 8999 -m state --state NEW -j ACCEPT 2>/dev/null
  fi
  isIpv6Exist=$(ip6tables-save | grep 8999 | grep tcp | grep ACCEPT)
  if [ "${isIpv6Exist}X" != "X" ];then
    ip6tables -D INPUT -p tcp -m tcp --dport 8999 -m state --state NEW -j ACCEPT 2>/dev/null
  fi
}

function unInstallRestCLI()
{
  CLI_LIST=$(ls ${CLI_PATH})
  for cli in $CLI_LIST; do
    if [ -d ${CLI_INSTALL_PATH}/${cli} ];then
      rm -rf ${CLI_INSTALL_PATH}/${cli}
      log_info "unInstall cmd ${cli} success"
    fi
  done
}

function stopRestProcess()
{
  su - rest -s "/bin/bash" -c "sh ${STOP_SCRIPT_PATH}" >> /dev/null 2>&1
  return "$?"
}

function deleteRestLogMonitorFromCrontab()
{
    cat "${CRONTAB_FILE_PATH}" | grep "restScriptLogMonitor.sh" >> /dev/null 2>&1
    if [ $? -eq 0 ];then
        delete_crontab_file "restScriptLogMonitor.sh "
        if [ $? -ne 0 ];then
            scriptExelog "Delete rest script log monitor in crontab failed [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
            return 1
        fi
    else
        scriptExelog "There has no rest script log monitor in crontab. [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
        return 0
    fi

    service crond reload >> $LOG_FILE 2>&1
    if [ $? -ne 0 ];then
        scriptExelog "Service crond reload failed [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
    fi

    local pid=$(ps -ef | grep restScriptLogMonitor | grep -v grep | awk -F " " '{print $2}')
    scriptExelog "Begin to kill rest script log monitor process, pid=${pid}. [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
    [[ ! -z "${pid}" ]] && kill -9 ${pid}
    return 0
}

#升级的卸载动作不需要删除日志
function uninstallProcessFile()
{
  [ -d /opt/dfv/oam/rest ] &&  rm -rf /opt/dfv/oam/rest
  if [ "${upgrade_flag}" -ne "1" ];then
    unRegisterLogCollection
    rm -rf /var/log/restconvert
  fi
  deleteTomcatTmpFile
  return $?
}

#注销日志收集
function unRegisterLogCollection()
{
  local targetFile=/opt/dfv/oam/public/script/collect_log/FusionStorage_oam-u/restConvert.sh
  if [ -f ${targetFile} ];then
    rm -f ${targetFile}
  fi
}

#升级的卸载动作不需要删除用户
function delRestUser()
{
  if [ "${upgrade_flag}" -eq "1" ];then
    return 0
  fi
  grep "^rest:" /etc/passwd >> /dev/null 2>&1
  local result=$?
  if [ $result -eq 0 ]; then
      userdel -r -f rest 2>/dev/null
      return $?
  fi
  return 0
}

#删除springboot启动tomcat产生的临时文件
function deleteTomcatTmpFile()
{
  su - rest -s "/bin/bash" -c "find /tmp -user rest | xargs rm -rf" >> /dev/null 2>&1
  return $?
}

if [ $# != 1 ]; then
	  echo "param num is must 1"
	  exit 1;
fi
if [ $1 -ne "1" ] && [ $1 -ne "0" ];then
    echo "param is must be 0 or 1, illegal param: $1"
    exit 1
fi
upgrade_flag=$1
main
ret=$?
[[ ${ret} -eq 0 ]] && echo "restConvert uninstall successfully!" || echo "restConvert uninstall failed!"
exit ${ret}