# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback

import utils.common.log as logger
from utils.common.message import Message
from utils.common.exception import HCCIException
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.Expansion.scripts.CloudService.implement.tc_expand_pool import ExpandPool


class ExpandPoolIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.params = ParamsGain(project_id, pod_id, self.db)
        self.fs_args = self.params.get_business_separate_expand_fusionstorage_args_while_new_pool_or_new_node()
        osd_nodes_info = self.db.get_install_os_list_info(pod_id=self.pod_id)
        for node in osd_nodes_info:
            node['om_ip'] = node.pop('manageIp')
        self.fs_args['ex_osd_list'] = osd_nodes_info

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建存储池，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            ExpandPool(project_id, pod_id, self.fs_args).procedure()
        except HCCIException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, HCCIException(626003, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
