# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback

import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import HCCIException
from plugins.DistributedStorage.Expansion.scripts.CloudService.implement.tc_expand_pool import ExpandPool
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain


class ExpandPoolIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args("master")
        ex_osd_list = list()
        for node in self.fs_args.get('all_openstack_nodes'):
            for osd in self.fs_args.get('osd_list'):
                if node.get('bmc_ip') == osd.get('bmc_ip'):
                    osd_node = dict(list(node.items()) + list(osd.items()))
                    osd_node['storage_pool_name_and_slot'] = osd_node.pop(
                        'manage_storage_pool_name')
                    ex_osd_list.append(osd_node)
        self.fs_args['ex_osd_list'] = ex_osd_list
        self.fs_args['default_pool_name'] = 'murano'

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建存储池，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            ExpandPool(project_id, pod_id, self.fs_args).procedure()
        except HCCIException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, HCCIException(626003, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
