# -*-coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import re
from plugins.DistributedStorage.utils.client.response_parse import ResponseParse


class RestResponse(ResponseParse):
    def __init__(self, res):
        super(RestResponse, self).__init__(res)

    def get_dsware_client_list(self):
        res = self.res.json()
        dsware_client_list = []
        if res.get('nodeMgrIp'):
            for ip in res.get('nodeMgrIp'):
                dsware_client_list.append(ip)
        return dsware_client_list

    def get_manage_cluster_name(self):
        res = self.res.json()
        if res.get('clusterName'):
            return res.get('clusterName')
        return ''

    def get_storage_pool_name(self):
        res = self.res.json()
        pool_name = ''
        if res.get('storagePools'):
            for pool in res.get('storagePools'):
                pool_name = pool.get('poolName')
                break
        return pool_name

    def get_dsware_client_count(self):
        res = self.res.json()
        dsware_client_count = 0
        if res.get('successDetail'):
            for _pool in res.get('successDetail'):
                dsware_client_count += 1
        return dsware_client_count

    def query_dr_cmd_result(self):
        res = self.res.json()
        create_result = 0
        if res.get('serviceCmdData'):
            for cmd_data in res.get('serviceCmdData'):
                ret_value = cmd_data.get('result')
                if 0 != int(ret_value):
                    create_result = 1
                    break
        else:
            create_result = 1
        return create_result

    def query_ip_pool_result(self):
        res = self.res.json()
        create_result = 0
        ip_pool_list = list()
        if res.get('serviceCmdData'):
            for cmd_data in res.get('serviceCmdData'):
                ret_value = cmd_data.get('result')
                if 0 != int(ret_value):
                    create_result = 1
                    break
                ip_pool_list.append(cmd_data.get('ipPoolIp'))
        else:
            create_result = 1
        return create_result, ip_pool_list

    def get_control_cluster_id(self):
        res = self.res.json()
        control_cluster_id = ""
        if res.get('serviceCmdData'):
            for cluster in res.get('serviceCmdData'):
                control_cluster_id = cluster.get('controlClusterId')
                break
        return str(control_cluster_id)

    def get_ip_pool_id(self, init_ip):
        pattern = re.compile(init_ip+"[@:]")
        res = self.res.json()
        ip_pool_id = ""
        if res.get('serviceCmdData'):
            for ip_pool in res.get('serviceCmdData'):
                pool_ips = ip_pool.get('ipPoolIp')
                if pattern.findall(pool_ips):
                    ip_pool_id = ip_pool.get('id')
                    break
        return str(ip_pool_id)

    def get_remote_init_ip(self, ip_pool_id):
        res = self.res.json()
        remote_init_ip = ""
        if res.get('serviceCmdData'):
            for ip_pool in res.get('serviceCmdData'):
                pool_id = ip_pool.get('id')
                if not pool_id:
                    break
                if pool_id == ip_pool_id:
                    pool_ips = ip_pool.get('ipPoolIp')
                    remote_init_ip = pool_ips.split(":")[1].split('@')[0]
                    break
        return remote_init_ip

    def get_remote_device_id(self, ip_list):
        res = self.res.json()
        remote_device_id = ""
        if res.get('serviceCmdData'):
            for remote_device_info in res.get('serviceCmdData'):
                local_ip = remote_device_info.get('initLocalIp')
                if not local_ip:
                    continue
                if local_ip in ip_list:
                    remote_device_id = remote_device_info.get('id')
                    break
        return str(remote_device_id)

    def get_rep_cls_sn(self):
        res = self.res.json()
        rep_cls_sn = ""
        if res.get('serviceCmdData'):
            for rep_cls_info in res.get('serviceCmdData'):
                rep_cls_sn = rep_cls_info.get('repClsSn')
                if rep_cls_sn:
                    break
        return rep_cls_sn

    def get_remote_sn(self, ip_list):
        res = self.res.json()
        remote_sn = ""
        if res.get('serviceCmdData'):
            for remote_device_info in res.get('serviceCmdData'):
                local_ip = remote_device_info.get('initLocalIp')
                if not local_ip:
                    continue
                if local_ip in ip_list:
                    remote_sn = remote_device_info.get('sn')
                    break
        return remote_sn

    def get_hyper_metro_domain_id(self, device_id):
        res = self.res.json()
        pattern = re.compile("\"devId\": *%s," % device_id)
        domain_id = ""
        if res.get('serviceCmdData'):
            for hyper_metro_info in res.get('serviceCmdData'):
                remote_device_info = hyper_metro_info.get('remoteDeviceId')
                if not remote_device_info:
                    continue
                if pattern.findall(remote_device_info):
                    domain_id = hyper_metro_info.get('hyperMetroDomainId')
                    break
        return str(domain_id)

    def get_quorum_server_id(self, quorum_server_ip):
        res = self.res.json()
        pattern = re.compile("%s:" % quorum_server_ip)
        server_id = ""
        state = None
        if res.get('serviceCmdData'):
            for quorum_server_info in res.get('serviceCmdData'):
                server_ips = quorum_server_info.get('quorumServerIp')
                if not server_ips:
                    continue
                if pattern.findall(server_ips):
                    server_id = quorum_server_info.get('id')
                    state = quorum_server_info.get("runningStatus")
                    break
        return str(server_id), state
