#!/bin/bash
. localrcs

TIMESTAMP=1234
CHECKTYPE=disable_jbod
CHECKRESULT=pass

### for Adaptec PMC 3152/2100
check_scsi_controller pmc && pmc_raid=1 || pmc_raid=0
if [ ${pmc_raid} != 0 ];then
    myCurl http://$FCDIP/tools/pmc/$(uname -m)/arcconf -o arcconf && chmod +x arcconf
    for i in {1..5};do
        ./arcconf setcontrollermode $i 3
    done
    modprobe -r smartpqi
    modprobe smartpqi
    CHECKOUTPUT='PMC: Successfully to disable JBOD'
    feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
    exit 0
fi

### for LSI MegaraidSAS
uname -r | grep x86 || {
    CHECKRESULT=pass
    CHECKOUTPUT="arch is arm"
    feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
    exit 1
}

check_scsi_controller || {
    CHECKRESULT=pass
	CHECKOUTPUT="RAID Controller is not supported, ignore"
	feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
	exit 1
}

myCurl http://$FCDIP/tools/MegaCli.zip -o MegaCli.zip
unzip -o MegaCli.zip || {
    CHECKRESULT=failed
	CHECKOUTPUT="113071,,http://$FCDIP/tools/MegaCli.zip"
	feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
	exit 1
}

OUTPUT=$(./MegaCli64 -AdpSetProp -EnableJbod -0 -aALL)
if [ $? -ne 0 ];then
    CHECKRESULT=failed
    CHECKOUTPUT="113064,,${OUTPUT}"
else
    modprobe -r megaraid_sas
    sleep 2
    modprobe megaraid_sas
    cd /sys/class/scsi_host/
    for i in *;do echo - - - >$i/scan;done
    CHECKRESULT=pass
    CHECKOUTPUT=${CHECKOUTPUT}" LSI: Successfully disable JBOD"
fi

feedback $TIMESTAMP $CHECKTYPE $CHECKRESULT "$CHECKOUTPUT"
