# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
冲裁服务器升级
"""
import os
import traceback

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.common.parameter_gain import ParamsGain
from plugins.DistributedStorage.Upgrade.scripts.impl.tc_quorum_service_upgrade import QuorumServiceUpgrade


class QuorumServiceUpgradeInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(QuorumServiceUpgradeInterface, self).__init__(project_id, pod_id)
        self.regionid_list = regionid_list
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list)\
            .get_args(suit_id)
        pkg_name, pkg_dir = ParamsGain(project_id, pod_id, regionid_list)\
            .get_quorum_package()
        self.fs_args["package_path"] = os.path.join(pkg_dir, pkg_name)
        self.fs_args["package_name"] = pkg_name

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start quorum service upgrade task')
        try:
            QuorumServiceUpgrade(project_id, pod_id, self.fs_args, self.regionid_list).procedure()
        except HCCIException as e:
            logger.error('quorum service  upgrade failed')
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            logger.error('dquorum service  upgrade task failed')
            return Message(500, HCCIException(621018, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('retry quorum service  upgrade task.')
        try:
            QuorumServiceUpgrade(project_id, pod_id, self.fs_args, self.regionid_list).procedure()
        except HCCIException as e:
            logger.error(traceback.format_exc())
            logger.error('retry quorum service  upgrade task failed')
            return Message(500, e)
        except Exception as e:
            logger.error('retry quorum service  upgrade failed')
            logger.error(traceback.format_exc())
            return Message(500, HCCIException(621018, str(e)))
        return Message(200)
