#!/bin/bash

readonly SCRIPTS_DIR=$(dirname "$(readlink -f "$0")")

function usage()
{
    echo "Usage: ${0##*/} {install|upgrade|uninstall} rootDir user group"
    exit 1
}

function doClear()
{
    local rootDir="$1"
    rm -rf "${rootDir}/dsware_api"
    return $?
}

function doUpdate()
{
    bash "${SCRIPTS_DIR}/update_dsware_api.sh" "$1" "$2" "$3"
    return $?
}

function doConfig()
{
    bash "${SCRIPTS_DIR}/config_dsware_api.sh" "$1" "$2" "$3"
    return $?
}

function main() {
    local action=$1
    case "${action}" in
        install)
            doConfig "$2" "$3" "$4"
            exit $?
            ;;
        upgrade)
            doUpdate "$2" "$3" "$4"
            exit $?
            ;;
        uninstall)
            doClear "$2"
            exit $?
            ;;
        *)
            usage
            ;;
    esac
}

main "$@"