#!/bin/bash

# DSWARE-API װڵĹؼĿ¼
readonly SCRIPTS_DIR=$(dirname "$(readlink -f "$0")")
readonly DSWARE_API_DIR="${SCRIPTS_DIR}/.."
readonly DSWARE_API_JAR_NAME="${DSWARE_API_DIR}/dsware-api-*.jar"
readonly LIB_DIR="${DSWARE_API_DIR}/lib"
readonly AARCH64_SO_DIR="${DSWARE_API_DIR}/lib/linux-aarch64"
readonly X86_64_SO_DIR="${DSWARE_API_DIR}/lib/linux-x86-64"
readonly X86_64="x86_64"
readonly AARCH64="aarch64"

# ĬΪ x86_64 ܹ
CPU_ARCH="x86_64"

# Ȩб
declare -A FILE_PERMISSION_LIST

function log()
{
    echo "$(date +'[%Y-%m-%d %H:%M:%S]') [$0:${BASH_LINENO[1]}] [${FUNCNAME[2]}] [$1] $2" >> "${DSWARE_API_LOG_PATH}" 2>&1
}

function checkOwner()
{
    if [ -z "${USER_NAME}" ] || [ -z "${GROUP_NAME}" ]; then
        log "ERROR" "The user or group is empty string!"
        return 1
    fi

    grep -Ew "^${USER_NAME}:.+" /etc/passwd >/dev/null 2>/dev/null || { log "ERROR" "The user is not exist!"; return 1; }
    grep -Ew "^${GROUP_NAME}:.+" /etc/group >/dev/null 2>/dev/null || { log "ERROR" "The group is not exist!"; return 1; }
    return 0
}

function setCpuArch()
{
    local arch=$(uname -a | grep -Eo "(${X86_64})|(${AARCH64})" | head -n1)
    [ -z "${arch}" ] && { log "ERROR" "unknown type of cpu arch!"; return 1; }

    CPU_ARCH="${arch}"
    return 0
}

function copyScripts()
{
    # Ҫõ shell չ '/*'
    rm -rf "${DSWARE_API_INSTALL_DIR:-"/opt/dsware/dsware_api"}"/scripts/*
    \cp -rpf "${SCRIPTS_DIR}"/* "${DSWARE_API_INSTALL_DIR}/scripts"
    return $?
}

function copyLibFile()
{
    # Ŀ¼Ĭֵ
    rm -rf "${DSWARE_API_INSTALL_DIR:-"/opt/dsware/dsware_api"}"/lib/*
    \cp -pf "${LIB_DIR}"/*.jar "${DSWARE_API_INSTALL_DIR}/lib"
    \cp -pf ${DSWARE_API_JAR_NAME} "${DSWARE_API_INSTALL_DIR}/lib"

    [ "${CPU_ARCH}" == "${X86_64}" ] && \cp -pf "${X86_64_SO_DIR}"/* "${DSWARE_API_INSTALL_DIR}/lib"
    [ "${CPU_ARCH}" == "${AARCH64}" ] && \cp -pf "${AARCH64_SO_DIR}"/* "${DSWARE_API_INSTALL_DIR}/lib"
    return 0
}

function setPermission()
{
    # Ȩǰ᣺FusionCompute ܺʹ洢ͬһڵ
    chown -Rh "${USER_NAME}:${GROUP_NAME}" "${DSWARE_API_INSTALL_DIR}"
    find "${DSWARE_API_INSTALL_DIR}" -type d -exec chmod 750 {} \;

    # ضȨãע⣺pathKey Ҫʹ shell չ
    for pathKey in "${!FILE_PERMISSION_LIST[@]}"; do
        chmod -R "${FILE_PERMISSION_LIST[${pathKey}]}" ${pathKey}
    done
}

function copyFiles()
{
    # ֻ lib ļͽűļ֤ļ kmc Կ
    copyLibFile || { log "ERROR" "Fail to copy lib files!!!"; return 1; }
    copyScripts || { log "ERROR" "Fail to copy scripts!!!"; return 1; }
    return 0
}

# ʼװõĿ¼
function initInstallEnv()
{
    # Ŀ¼Ŀ¼
    DSWARE_API_INSTALL_DIR="${ROOT_DIR}/dsware_api"
    KMC_DIR="${DSWARE_API_INSTALL_DIR}/kmc"

    # Ŀ¼Ȩ
    FILE_PERMISSION_LIST=(
        ["${DSWARE_API_INSTALL_DIR}/cert/*"]="640"
        ["${DSWARE_API_INSTALL_DIR}/lib/*"]="550"
        ["${DSWARE_API_INSTALL_DIR}/scripts/*"]="550"
        ["${KMC_DIR}/conf/*"]="640"
        ["${KMC_DIR}/bkp/*"]="640"
    )
}

function initLogDir()
{
    DSWARE_API_LOG_DIR="${ROOT_DIR}/dsware_api/log"
    DSWARE_API_LOG_PATH="${DSWARE_API_LOG_DIR}/dsware_api.log"
    [ ! -d "${DSWARE_API_LOG_DIR}" ] && mkdir -p "${DSWARE_API_LOG_DIR}"
    chmod 750 "${DSWARE_API_LOG_DIR}"

    [ ! -f "${DSWARE_API_LOG_PATH}" ] && touch "${DSWARE_API_LOG_PATH}"
    chmod 640 "${DSWARE_API_LOG_PATH}"

    return $?
}

function main()
{
    [ "$#" -ne 3 ] && return 1
    ROOT_DIR="$1"
    USER_NAME="$2"
    GROUP_NAME="$3"
    # ʱڰװĿ¼߰װ
    if [ ! -d "${ROOT_DIR}/dsware_api" ]; then
        bash ./config_dsware_api.sh "${ROOT_DIR}" "${USER_NAME}" "${GROUP_NAME}"
        # ־·
        DSWARE_API_LOG_PATH="${ROOT_DIR}/dsware_api/log/dsware_api.log"
        log "WARN" "can not upgrade, do install!!!"
        return $?
    fi

    initLogDir || return 1
    initInstallEnv || { log "ERROR" "init install environment failure!!!"; return 1; }

    log "INFO" "start to update dsware_api."
    checkOwner || { log "ERROR" "invalid user or group!!!"; return 1; }
    setCpuArch || { log "ERROR" "Fail to set cpu arch type!!!"; return 1; }
    copyFiles || { log "ERROR" "Fail to copy files!!!"; return 1; }
    setPermission || { log "ERROR" "Fail to set permission!!!"; return 1; }
    log "INFO" "update dsware_api end."
    return 0
}

main "$@"