#!/bin/bash

if [ `echo "$0" |grep -c "/"` -gt 0 ]; then
    cd ${0%/*}
fi
configPath=/var/shell/restagent/config.inc

. $configPath

#tomcat端口
typeset tomcat_port=$(grep "tomcat_port=" $configPath | awk -F= '{print $2}')
	
#sharedrive   restagent本地目录
typeset sharedrive=$(grep "sharedrive=" $configPath | head -1 | awk -F= '{print $2}')
	
#server_pacific
typeset server_pacific=$(grep "server_pacific=" $configPath | awk -F= '{print $2}')

typeset namespace=$(grep "namespace=" $configPath | awk -F= '{print $2}')

typeset path=$(grep "path=" $configPath | awk -F= '{print $2}')

typeset everyone_acl_button=$(grep "everyone_acl_button=" $configPath | awk -F= '{print $2}')
typeset supportnoroot=$(grep "open_no_root=" $configPath | awk -F= '{print $2}')

user_name=restagentusr
user_group=restagentgroup

typeset INTERVAL=10
typeset MAX_TIME_OUT=3
typeset time=0
typeset MAX_TIME=3
typeset logfile=/var/log/restagent/cur_log/logfile
function setPremission()
{
    chmod 750 ${path} -R 
    chmod 550 ${path}/apache-tomcat/lib -R
    chmod 550 ${path}/apache-tomcat/bin -R

    chmod 600 ${path}/apache-tomcat/conf/ -R
    chmod 700 ${path}/apache-tomcat/conf 
    chmod 600 ${path}/apache-tomcat/kmc -R
    chmod 700 ${path}/apache-tomcat/kmc
    chmod 500 ${path}/apache-tomcat/kmclib -R
	
    chmod 750 /var/log/restagent
    chmod 750 /var/log/restagent/cur_log
    chmod 640 /var/log/restagent/cur_log/logfile
    chmod 750 /var/log/restagent/his_log

    mkdir -p /home/jsonbak/
    chmod 750 /home/jsonbak/ -R

    chown -h ${user_name}:${user_group} ${path} -R
    chown -h ${user_name}:${user_group} /var/log/restagent -R
    chown -h ${user_name}:${user_group} /home/jsonbak/ -R

    chmod 550 ${path}/jre -R
    chown -h ${user_name}:${user_group} ${path}/jre -R
}

function startTomcat
{	
        echo "`date +"%Y-%m-%d %X"` tomcat is starting...."  >> ${logfile}
        while true
		do
		cd ${path}/apache-tomcat/bin
		#启动tomcat
		if [ x"${supportnoroot}" = x"true" ];then
            setPremission
            su - ${user_name} -s /bin/bash -c "export JRE_HOME=$path/jre;export LD_LIBRARY_PATH=${path}/apache-tomcat/kmclib;${path}/apache-tomcat/bin/startup.sh  >> ${logfile}"
		else
            export JRE_HOME=$path/jre;
            export LD_LIBRARY_PATH=${path}/apache-tomcat/kmclib;
            ./startup.sh  >> ${logfile}
		fi
		if [ $? -ne 0 ]
		then
			exit 1
		fi
		#清空日志
		cd ../logs;
		>catalina.out
#		echo "*********************************************************************"
		time_out=0
		while true
		do
#			echo "tomcat is starting..."
			sleep ${INTERVAL}
			#启动成功
			echo "`date +"%Y-%m-%d %X"` Check if tomcat is started...."  >> ${logfile}
#			echo "Check if tomcat is started...."
			if [ `grep -c 'Server startup in'  catalina.out` -ne 0 ]
			then
				start_flag=1
				echo "`date +"%Y-%m-%d %X"` tomcat is started successfully!" >> ${logfile}
				echo "`date +"%Y-%m-%d %X"` tomcat is started successfully!"
				break
			else
				echo "`date +"%Y-%m-%d %X"` tomcat is still starting...." >> ${logfile}
#				echo "tomcat is still starting....";
			fi
			
			
			echo "`date +"%Y-%m-%d %X"` Check if tomcat is stoped...."  >> ${logfile}
#			echo "Check if tomcat is stoped...."
			if [ `grep  -c 'Destroying ProtocolHandler' catalina.out`  -ne 0 ]
			then	
				echo "`date +"%Y-%m-%d %X"` tomcat is stopped..."  >> ${logfile}
#				echo "tomcat is stopped..."
				start_flag=0
				break;
			else
				echo "`date +"%Y-%m-%d %X"` tomcat is still starting..."  >> ${logfile}
#				echo "tomcat is still starting..."
			fi
			
			time_out=`expr $time_out + 1`
			if [ $time_out -eq $MAX_TIME_OUT ];then
				start_flag=0
				break
			fi
		done 
		
		#启动失败
		if [ $start_flag -eq 0 ];then
			pss=`ps -eaf | grep -v grep | grep tomcat | grep java | awk '{print $2}'`
			if [ ! -z "$pss" ];then
				kill -9 $pss
			fi
			
			#重试的次数小于自定义数（3），继续尝试启动。
			if [ $time -lt $MAX_TIME ];then
				time=`expr $time + 1`
				echo "`date +"%Y-%m-%d %X"` Try again.."  >> ${logfile}
#				echo "Try again.."
				continue;
			else
				break
			fi
		else
		    break
		fi
		
	 done   

	
			
	cd ../..
	if [ $start_flag -eq 0 ]
	then
		echo "`date +"%Y-%m-%d %X"` Start tomcat failure."  >> ${logfile}
		echo "`date +"%Y-%m-%d %X"` Start tomcat failure.";
		#exit 1
	#else
		#exit 0
	fi
	echo "`date +"%Y-%m-%d %X"` tomcat start end...."  >> ${logfile}
}
function stopTomcat
{
		cd ${path}/apache-tomcat/bin
		export JRE_HOME=$path/jre;
		#停止tomcat
		./shutdown.sh  >> ${logfile}
		if [ $? -ne 0 ]
		then
			exit 1
		fi
		#清空日志
		cd ../logs;
		>catalina.out
		#echo "*********************************************************************"
		time_out=0
		while true
		do
#			echo "tomcat is stopping...."
			sleep ${INTERVAL}
			#停止成功
			echo "`date +"%Y-%m-%d %X"` Check if tomcat has stopped...." >> ${logfile}
#			echo "Check if tomcat has stopped...."
			if [ `grep  -c 'Destroying ProtocolHandler'  catalina.out` -ne 0 ]
			then
				start_flag=1
				echo "`date +"%Y-%m-%d %X"` tomcat has stopped successfully!" >> ${logfile}
				echo "`date +"%Y-%m-%d %X"` tomcat has stopped successfully!"
				break
			else
				echo "`date +"%Y-%m-%d %X"` tomcat has stopped...." >> ${logfile}
#				echo "tomcat has stopped...."
			fi
			time_out=`expr $time_out + 1`
			if [ $time_out -eq $MAX_TIME_OUT ];then
				start_flag=0
				break
			fi
		done
		
	cd ../..
	if [ $start_flag -eq 0 ]
	then
		echo "`date +"%Y-%m-%d %X"` stop tomcat failure or stop has stopped." >> ${logfile}
		echo "`date +"%Y-%m-%d %X"` stop tomcat failure or stop has stopped."
		#exit 1
	#else
		#exit 0
	fi
	
	# 停止完成后再检查下进程
	pids=`ps -eaf | grep -v grep | grep apache-tomcat | grep java | awk '{print $2}'`
	for pid in $pids
	do
		kill -9 $pid
	done
}

function start
{
killall watchdog_nasrestagent.sh
./watchdog_nasrestagent.sh &
echo "`date +"%Y-%m-%d %X"` watchdog start success..." >> ${logfile}
echo "`date +"%Y-%m-%d %X"` watchdog start success..."
}

function stop
{
 killall watchdog_nasrestagent.sh
 echo "`date +"%Y-%m-%d %X"` watchdog stop success..." >> ${logfile}
 echo "`date +"%Y-%m-%d %X"` watchdog stop success..."
}

typeset interval_time=120

typeset restart_time=90

function setMount
{

if [ `echo "$0" |grep -c "/"` -gt 0 ]; then
    cd ${0%/*}
fi

#加载配置文件
function get_config
{
	if [ -f $configPath ];then
		. $configPath
		echo "`date +"%Y-%m-%d %X"` load file success" >> ${logfile}
	else
		echo "`date +"%Y-%m-%d %X"` Couldn't find the file config.inc.[failed]" >> ${logfile}
		return 1
	fi
}


#挂载配置
function configmount
{	

	typeset mountornot=`mount  | grep " ${sharedrive} "  | wc -l` >/dev/null 2>&1

	echo "`date +"%Y-%m-%d %X"` mount:${mountornot}"
	#如果显示为非0，则说明已经挂载。如果显示0 ，表示需要进行挂载。
	if [ ${mountornot} -eq 0 ];then
		if [ -d $classes_dir ];then
			mkdir -p ${sharedrive}
		fi
		#检查是否将pacific挂在到本地目录
		mount -t nfs4 -o minorversion=1 ${server_pacific}:/${namespace} ${sharedrive}/   >/dev/null 2>&1
		echo "`date +"%Y-%m-%d %X"` set mount" 
		#需要进行异常判断
		typeset mountflag=`mount  | grep " ${sharedrive} "  | wc -l`
		echo "`date +"%Y-%m-%d %X"` mount:${mountflag}"
		 if [ ${mountflag} -eq 0 ];then
			#检查是否设置owner权限
			# typeset ownerflag = `nfs4_getfacl ${sharedrive}/ | grep 'A:fd:OWNER@rwaDxtTnNcCy' | wc -l`
			#如果是0 ，则表示没有设置
			# if [ ${ownerflag} -eq 0 ];then
				# nfs4_getfacl -s A:fd:OWNER@rwaDxtTnNcCy ${sharedrive}
				# typeset nfsmoug = `nfs4_getfacl ${sharedrive}/ | grep 'A:fd:OWNER@rwaDxtTnNcCy' | wc -l`
				# if [ ${nfsmoug} -ne 0 ];then
					# echo "set owner successful"
				# else
					# echo "set owner fail"
				# fi				
			# fi
		# else
	    echo "mount ${server_pacific}:/${namespace} to ${sharedrive} fail"
		fi
	fi
	
	#检查是否设置owner权限
	typeset ownerflag=`nfs4_getfacl ${sharedrive}/ | grep 'A:fd:OWNER@:rwaDxtTnNcCy' | wc -l` >/dev/null 2>&1
	echo "`date +"%Y-%m-%d %X"` owner:${ownerflag}"
	#如果是0 ，则表示没有设置
	if [ ${ownerflag} -eq 0 ];then
		nfs4_setfacl -s A:fd:OWNER@:rwaDxtTnNcCy ${sharedrive} >/dev/null 2>&1
		typeset nfsmoug=`nfs4_getfacl ${sharedrive}/ | grep 'A:fd:OWNER@:rwaDxtTnNcCy' | wc -l` >/dev/null 2>&1
		if [ ${nfsmoug} -ne 0 ];then
			echo "`date +"%Y-%m-%d %X"` set owner successful" >> ${logfile}
		else
			echo "`date +"%Y-%m-%d %X"` set owner fail" >> ${logfile}
		fi				
	fi
	
	#检查是否设置everyone权限
	typeset everyone_acl="rxy";
	if [ ${everyone_acl_button} = "open" ];then
	   everyone_acl="xy"
	fi
	typeset everyoneflag=`nfs4_getfacl ${sharedrive} | grep 'A::EVERYONE@:rxtncy' | wc -l` >/dev/null 2>&1
	echo "`date +"%Y-%m-%d %X"` everyone:${everyoneflag}"
	#如果是0 ，则表示没有设置
	if [ ${everyoneflag} -eq 0 ];then
		nfs4_setfacl -a A::EVERYONE@:rxtncy ${sharedrive} >/dev/null 2>&1
		typeset nfsmoug=`nfs4_getfacl ${sharedrive} | grep 'A::EVERYONE@:rxtncy' | wc -l` >/dev/null 2>&1
		if [ ${nfsmoug} -ne 0 ];then
			echo "`date +"%Y-%m-%d %X"` set everyone successful" >> ${logfile}
		else
			echo "`date +"%Y-%m-%d %X"` set everyone fail" >> ${logfile}
		fi				
	fi
	
	#检查pacific的IP是否ping通
	typeset pingflag=`ping -c 3 ${server_pacific} >/dev/null 2>&1 |grep 'errors'| awk -F, '{print $3}' | wc -l` >/dev/null 2>&1
	if [  $pingflag -ne "0" ];then
		echo  "`date +"%Y-%m-%d %X"` ping ${server_pacific} failed ,please check the network first" >> ${logfile}		
	fi
}

#查看端口8443是否被使用
typeset checkport=`lsof -i:${tomcat_port} | wc -l` >/dev/null 2>&1
if [  $checkport -ne "0" ];then
	#echo "-----------------------executed setMount.sh start.---------------------------------"

	#加载配置文件
	#get_config
	# if [ $? -ne 0 ];then
		# exit 255
	# fi

	#挂载以及设置权限操作
	configmount >> ${logfile}
	if [ $? -ne 0 ];then
		exit 255
	fi
	#echo "------------------------executed setMount.sh end.---------------------------------"
#else
	#echo "tomcat has not run"
fi





}

case "$1" in
    startTomcat)
        startTomcat
		exit $?
        ;;
        
    stopTomcat)
	    stopTomcat
		exit $?
        ;;    

    setMount)
        setMount
        exit $?
        ;;	

    start)
        start
        exit $?
        ;;	
     stop)
        stop
        exit $?
        ;;   		
esac

function logBackup
{
  if [ ! -d /var/log/restagent ];then
    mkdir /var/log/restagent
  fi
  if [ ! -d /var/log/restagent/cur_log ];then
    mkdir /var/log/restagent/cur_log
  fi
  if [ ! -d /var/log/restagent/his_log ];then
    mkdir /var/log/restagent/his_log
  fi
  cd /var/log/restagent/cur_log  
  logNum=`ls -l|grep "^-"|wc -l`
  #echo $logNum
  logNum=$[ $logNum-1 ]
  #echo $logNum
  logSize=$[ 10*$logNum ]
  #echo $logSize
  if [ $logSize -gt 20 ];then
     cur_date=`date '+%Y%m%d-%H%M%S'`
	 cd /var/log/restagent
     tar -zcf restagent.log.${cur_date}.tar.gz cur_log 
	 rm -f /var/log/restagent/cur_log/restagent.log.*
	 if [ -f restagent.log.${cur_date}.tar.gz ];then
	    mv restagent.log.${cur_date}.tar.gz /var/log/restagent/his_log  >/dev/null 2>&1
	 fi
	 > ${logfile}
  fi
  cd /var/log/restagent/his_log
  zipnum=`ls -l|grep "^-"|wc -l`
  if [ ${zipnum} -gt 100 ];then 
      delnum=$[ ${zipnum}-100 ]
      name=`ls -t restagent.log*|tail -${delnum}`
      #ls -t restagent.log*|tail -${delnum}
     for i in ${name}
         do 
          rm ${i}
         done
  fi
}


while true
do
    #判断tomcat进程是否存在
#	echo "check tomcat status....."
    typeset progress=`ps -eaf | grep -v grep | grep apache-tomcat | grep java | wc -l`
	#判断端口是否被占用
	typeset portUsed=`lsof -i:${tomcat_port} | wc -l`
	if [ ${progress} -eq 0 ] || [ ${portUsed} -eq 0 ];then
	   echo "`date +"%Y-%m-%d %X"` tomcat exception....." >> ${logfile}
#	   echo "tomcat exception....."
	   #stop
	   #sleep ${restart_time}
	   stopTomcat
	   startTomcat
	 fi
	 cd ${path}
     setMount >> ${logfile}
	 logBackup
#     if [ $? -eq 0 ];then
#		echo "setMount.sh execute success."
#	 else
#		echo "setMount.sh execute failure."
#    fi 
#     echo "check complete,will next check....."
	 sleep ${interval_time}		 
done

