#!/usr/bin/env bash

source /opt/dfv/oam/oam-u/ha/ha.conf >/dev/null 2>&1

SHELL_LOG_DIR=""
SHELL_LOG_NAME=""
SHELL_LOG_FULL_PATH=""
USER_LOCK_FILE="${SHELL_LOG_DIR}/.user_mutex"
HA_NOTIFY_LOCK_FILE="${SHELL_LOG_DIR}/.notify_ha_mutex"
CRONTAB_FILE_PATH="/var/spool/cron/root"
CRONTAB_LOCK_FILE=/${SHELL_LOG_DIR}/.crontab

OAM_SYS_USER=rest
OAM_SYS_GROUP=oam
GROUP_OAM_ID=5001
USER_OAM_ID=6001
COMMON_GROUP="storage"

SERVICE_FLOAT_IP="${FLOAT_IP}"
ACTIVE_IP="${ACTIVE_ADDRESS}"
STANDBY_IP="${STANDBY_ADDRESS}"

IS_IPV4="^([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]{1,2}|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$"
IS_IPV6="^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|[01]?\d\d?)\
(\.(25[0-5]|2[0-4]\d|[01]?\d\d?)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|[01]?\d\d?)\
(\.(25[0-5]|2[0-4]\d|[01]?\d\d?)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:\
((25[0-5]|2[0-4]\d|[01]?\d\d?)(\.(25[0-5]|2[0-4]\d|[01]?\d\d?)){3}))|:))|\
(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:\
((25[0-5]|2[0-4]\d|[01]?\d\d?)(\.(25[0-5]|2[0-4]\d|[01]?\d\d?)){3}))|:))|\
(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4})\
{0,3}:((25[0-5]|2[0-4]\d|[01]?\d\d?)(\.(25[0-5]|2[0-4]\d|[01]?\d\d?)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}\
(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|[01]?\d\d?)(\.(25[0-5]|2[0-4]\d|[01]?\d\d?)){3}))|:))\
|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|[01]?\d\d?)(\.(25[0-5]|2[0-4]\d|[01]?\d\d?)){3}))|:)))(%.+)?\s*$"


CLI_INSTALL_PATH=/opt/dfv/oam/oam-u/ismcli/cmd_autogen

function initLog()
{
    SHELL_LOG_DIR=$1
    SHELL_LOG_NAME=$2

    mkdir -p ${SHELL_LOG_DIR}
    SHELL_LOG_FULL_PATH="${SHELL_LOG_DIR}/${SHELL_LOG_NAME}"

    if [ ! -f "${SHELL_LOG_FULL_PATH}" ]; then
        touch "${SHELL_LOG_FULL_PATH}"
    fi
    chmod 640 ${SHELL_LOG_FULL_PATH}

    return 0
}

#===  FUNCTION  ================================================================
#         NAME: LOG
#      PURPOSE: print log
#   PARAMETERS: NA
#      RETURNS: NA
#===============================================================================
function scriptExelog()
{
    local param1=$1
    local param2=$2
    local param3=$3
    local owner=$(ls -lt ${SHELL_LOG_FULL_PATH} | awk '{print $3}')
    if [ "$(whoami | awk '{print $1}')" == "root" ] && [ "X$owner" != "Xroot" ];then
        if [[ -n $owner ]] && [[ -n $(grep -w "^$owner" /etc/passwd) ]];then
            su - ${owner} -s "/bin/bash" -c "echo \"[\"\"$(date +'%F %T')\"\"]\"\"[\"\"${param1}\"\"]\"\"[\"\"${param2}\"\"]\"\"[\"\"${param3}\"\"]\" >> \"${SHELL_LOG_FULL_PATH}\" 2>/dev/null"
        fi
    else
        echo "[""$(date +'%F %T')""]""[""${param1}""]""[""${param2}""]""[""${param3}""]" >> "${SHELL_LOG_FULL_PATH}" 2>/dev/null
    fi
    return 0
}

function scriptPrintLog()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[""$(date +'%F %T')""]""[""${param1}""]"
    scriptExelog "${param1}" "${param2}" "${param3}"
    return 0
}

alias log_info='writeLog "INFO " "${LINENO}" "${FUNCNAME}" "${scriptName}"'
alias log_warn='writeLog "WARN " "${LINENO}" "${FUNCNAME}" "${scriptName}"'
alias log_error='writeLog "ERROR" "${LINENO}" "${FUNCNAME}" "${scriptName}"'
function writeLog()
{
    local log_level="$1"
    local log_line="$2"
    local log_func="$3"
    local log_script="$4"
    local log_msg="$5"

    scriptExelog "${log_level}:${log_msg} Line:${log_line}" "${log_func}" "${log_script}"
}

alias print_info='printLog "INFO " "${LINENO}" "${FUNCNAME}" "${scriptName}"'
alias print_warn='printLog "WARN " "${LINENO}" "${FUNCNAME}" "${scriptName}"'
alias print_error='printLog "ERROR" "${LINENO}" "${FUNCNAME}" "${scriptName}"'
function printLog()
{
    local log_level="$1"
    local log_line="$2"
    local log_func="$3"
    local log_script="$4"
    local log_msg="$5"

    scriptPrintLog "${log_level}:${log_msg} Line:${log_line}" "${log_func}" "${log_script}"
}

alias log_exit='printErrorAndExit "ERROR" "${LINENO}" "${FUNCNAME}" "${scriptName}"'
function printErrorAndExit()
{
    local log_level="$1"
    local log_line="$2"
    local log_func="$3"
    local log_script="$4"
    local log_msg="$5"

    scriptPrintLog "${log_level}:${log_msg} Line:${log_line}" "${log_func}" "${log_script}"
    exit 1
}

function addUser_Group()
{
    index=0
    while ((index < 10))
    do
        addUser_GroupSafety "$@"
        [[ $? -eq 0 ]] && return 0
        let index=index+1
        sleep 1
        scriptExelog "addUser_Group failed ${index}th..." ${FUNCNAME} ${scriptName}
    done

    return 1
}

function addUser_GroupSafety()
{
    flock -w 60 503
    [[ $? -ne 0 ]] && echo "wait 60s, mergeVersion time out" && return 1

    local user=$1
    local userId=$2
    local group=$3
    local groupId=$4

    #add the group
    grep "^${group}:" /etc/group >> "${SHELL_LOG_FULL_PATH}" 2>&1
    if [ $? -ne 0 ]; then
        scriptExelog "add group start...[Line:${LINENO}]" ${FUNCNAME} ${scriptName}
        grep ":${groupId}:$" /etc/group >> "${SHELL_LOG_FULL_PATH}" 2>&1
        [[ $? -eq 0 ]] && scriptExelog "groupId has been used already![Line:${LINENO}]" ${FUNCNAME} ${scriptName} && return 1
        groupadd -g ${groupId} ${group}
        [[ $? -ne 0 ]] && scriptExelog "failed to add group![Line:${LINENO}]" ${FUNCNAME} ${scriptName} && return 1
    fi

    grep "^${user}:" /etc/passwd >> "${SHELL_LOG_FULL_PATH}" 2>&1
    result=$?
    if [ $result -ne 0 ]; then
        scriptExelog "add user start...[Line:${LINENO}]" ${FUNCNAME} ${scriptName}
        grep ":${userId}:$" /etc/passwd >> "${SHELL_LOG_FULL_PATH}" 2>&1
        [[ $? -eq 0 ]] && scriptExelog "userId has been used already![Line:${LINENO}]" ${FUNCNAME} ${scriptName} && return 1
        useradd ${user} -m -e 99999  -d  /home/${user} -g ${group} -u ${userId} -s /sbin/nologin >> "${SHELL_LOG_FULL_PATH}" 2>&1
        [[ $? -ne 0 ]] && scriptExelog "failed to add user![Line:${LINENO}]" ${FUNCNAME} ${scriptName} && return 1

    else
        cat /etc/passwd | grep "^${user}:x:${userId}:"  >> "${SHELL_LOG_FULL_PATH}" 2>&1
        [[ $? -ne 0 ]] && scriptExelog "userId is invalid! expect userId=${userId}[Line:${LINENO}]" ${FUNCNAME} ${scriptName} && return 1
    fi

    scriptExelog "add ${user} User success.[Line:${LINENO}]" ${FUNCNAME} ${scriptName}
    return 0
} 503<>${USER_LOCK_FILE}

#重启HA来加载资源变更
function notify_ha()
{
    local action=$1
    local res_name=$2
    local ha_install_path="/opt/dfv/oam/oam-u/ha/ha"
    local ha_status_script="${ha_install_path}/module/hacom/script/status_ha.sh"
    local ha_stop_script="${ha_install_path}/module/hacom/script/stop_ha_process.sh"
    local ha_local_conf="${ha_install_path}/local/hacom/conf/hacom_local.xml"

    flock -w 60 507 ||  { log_error "wait 60s, get file lock time out.";return 1; }

    local node_name=$(awk -F "=" '/local name/{print $2;exit}' ${ha_local_conf} 2>/dev/null | awk '{print $1}' | sed 's/[^a-z0-9]//g')
    if [ -z "${node_name}" ]; then
        log_error "Failed to get ha node name."
        return 1
    fi

    local count=0
    local max_count=3
    while [[ "${count}" -lt "${max_count}" ]]
    do
        ((count++))
        sh ${ha_stop_script} >>${SHELL_LOG_FULL_PATH} 2>&1
        [ $? -ne 0 ] && log_warn "Stop ha process failed, try again!"
        sleep 45

        log_info "begin to check restult, action :${action}..."
        local status=$(sh ${ha_status_script} 2>>${SHELL_LOG_FULL_PATH} | fgrep -w ${node_name} | fgrep -w "${res_name}")
        if [[ "x${action}" == x"register" ]] && [[ -z "${status}" ]]; then
            log_warn "The ${res_name} plugin not exist, try to notify ha again!"
            continue
        fi
        if [[ "x${action}" == x"unregister" ]] && [[ -n "${status}" ]]; then
            log_warn "The ${res_name} plugin still exist, try to notify ha again!"
            continue
        fi

        log_info "${action} ${res_name} plugin success."
        return 0
    done

    log_error "notify ha plugin failed."
    return 1
} 507<>${HA_NOTIFY_LOCK_FILE}

#将RestConvert向HA注册的配置文件和管理脚本放到指定路径
function registerHAPlugin()
{
    local ha_path="/opt/dfv/oam/oam-u/ha/ha"
    local public_ha_path="/opt/dfv/oam/public/ha"

    cp -a ${INSTALL_PATH}/RestConvert/RestConvert.xml ${ha_path}/module/harm/plugin/conf/ >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    cp -f ${INSTALL_PATH}/RestConvert/RestConvert-file.xml ${ha_path}/module/hasync/plugin/conf/ >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    cp -f ${INSTALL_PATH}/RestConvert/RestConvert.sh ${ha_path}/module/harm/plugin/script/ >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    cp -a ${INSTALL_PATH}/RestConvert/RestConvert.xml ${public_ha_path}/conf/ >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    cp -f ${INSTALL_PATH}/RestConvert/RestConvert-file.xml ${public_ha_path}/syncconf/ >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    cp -f ${INSTALL_PATH}/RestConvert/RestConvert.sh ${public_ha_path}/script/ >>${SHELL_LOG_FULL_PATH} 2>&1

    chmod 640 ${ha_path}/module/harm/plugin/conf/RestConvert.xml
    chown root:oam ${ha_path}/module/harm/plugin/conf/RestConvert.xml
    chmod 640 ${public_ha_path}/conf/RestConvert.xml
    chown root:oam ${public_ha_path}/conf/RestConvert.xml

    chmod 640 ${ha_path}/module/hasync/plugin/conf/RestConvert-file.xml
    chown root:oam ${ha_path}/module/hasync/plugin/conf/RestConvert-file.xml
    chmod 640 ${public_ha_path}/syncconf/RestConvert-file.xml
    chown root:oam ${public_ha_path}/syncconf/RestConvert-file.xml

    chmod 750 ${ha_path}/module/harm/plugin/script/RestConvert.sh
    chown root:oam ${ha_path}/module/harm/plugin/script/RestConvert.sh
    chmod 750 ${public_ha_path}/script/RestConvert.sh
    chown root:oam ${public_ha_path}/script/RestConvert.sh

    if [ $? -ne 0 ];then
        log_exit "Copy file to ha resource faild."
    fi
    echo "begin to register HA..."
    notify_ha "register" "RestConvert"
    [ $? -ne 0 ] && log_exit "notify_ha to register failed!"
    echo "register HA ok"
    return 0
}

function unRegisterHAPlugin()
{
    local ha_path="/opt/dfv/oam/oam-u/ha/ha"
    local public_ha_path="/opt/dfv/oam/public/ha"

    rm -f ${ha_path}/module/harm/plugin/conf/RestConvert.xml >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    rm -f ${ha_path}/module/hasync/plugin/conf/RestConvert-file.xml >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    rm -f ${ha_path}/module/harm/plugin/script/RestConvert.sh >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    rm -f ${public_ha_path}/conf/RestConvert.xml >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    rm -f ${public_ha_path}/syncconf/RestConvert-file.xml >>${SHELL_LOG_FULL_PATH} 2>&1 &&
    rm -f ${public_ha_path}/script/RestConvert.sh >>${SHELL_LOG_FULL_PATH} 2>&1

    if [ $? -ne 0 ];then
        log_exit "remove file from ha resource faild."
    fi
    echo "begin to unregister HA..."
    notify_ha "unregister" "RestConvert"
    [ $? -ne 0 ] && log_exit "notify_ha to unregister failed!"
    echo "unregister HA ok"
    return 0
}

function isValidIP()
{
    isSuseOs
    if [ $? -eq 0 ]; then
        checkIp "$1" && return 0 || return 1
    else
        ipcalc -cs "$1" && return 0 || return 1
    fi
}

#===============================================================================
# 函数：isEulerOs
# 功能：根据/etc/euleros-latest文件内容判断是否为欧拉系统
#===============================================================================
function isSuseOs()
{
    os_name=$(cat /etc/os-release 2> /dev/null | grep "^NAME\s*=" | awk -F "=" '{print $2}')

    if [ "X${os_name}" == "X\"SLES\"" ]; then
        scriptExelog "check os is suse. [Line:${LINENO}]"
        return 0
    fi

    return 1
}

function checkDiskSpace()
{
    log_info "checkDiskSpace check path is $1"
    installPath=$1;
    installPackageSize=$2;
    freeSize=`df $installPath | tail -n 1 | awk '{print $4}'`;

    if [ $installPackageSize -gt $freeSize ]; then
        log_error "path:${installPath},freeSize:${freeSize} less than ${installPackageSize}"
	      return 1
    fi
	  return 0
}

function setJre()
{
    local jrePath=$1
    if [ -z "${jrePath}" ];then
        scriptExelog "jrePath: ${jrePath} is empty.[Line:${LINENO}]"
        return 1
    fi
    chmod 750 ${jrePath} -R
    chmod 550 ${jrePath}/bin -R
    chmod 640 ${jrePath}/LICENSE
    chmod 640 ${jrePath}/lib/security/*
    chmod 550 ${jrePath}/lib/security/policy -R
    chmod 550 ${jrePath}/lib/jexec
    chmod 640 ${jrePath}/lib/jvm.hprof.txt
    chmod 640 ${jrePath}/THIRD_PARTY_README
    chmod 640 ${jrePath}/ASSEMBLY_EXCEPTION
    chmod 550 ${jrePath}/lib/applet

    chmod 640 ${jrePath}/lib/cmm/*
    chmod 640 ${jrePath}/lib/management/*

    local type=`uname -m`
    if [ "${type}" = "x86_64" ];then
      type="amd64"
    fi
    chmod 750 ${jrePath}/lib/${type}
    chmod 550 ${jrePath}/lib/${type}/* -R
    chmod 640 ${jrePath}/lib/${type}/jvm.cfg
    chmod 750 ${jrePath}/lib/${type}/server
    chmod 640 ${jrePath}/lib/${type}/server/Xusage.txt
    chmod 640 ${jrePath}/lib/classlist
    chmod 640 ${jrePath}/lib/ext/meta-index
    chmod 640 ${jrePath}/lib/fonts/Roboto-Regular.ttf
    chmod 640 ${jrePath}/lib/currency.data
    chmod 640 ${jrePath}/lib/meta-index
    chmod 640 ${jrePath}/lib/psfont.properties.ja
    chmod 640 ${jrePath}/lib/tzdb.dat

    #change some file permission
    soFiles=$(find ${jrePath}/ -name "*.so")
    chmod 550 ${soFiles}
    jarFiles=$(find ${jrePath}/ -name "*.jar")
    chmod 550 ${jarFiles}
    scriptExelog "INFO:chmod jarFiles permission, jrePath: ${jrePath}, return value: $?.[Line:${LINENO}]" ${FUNCNAME} ${scriptName}
    txtFiles=$(find ${jrePath}/ -name "*.txt")
    chmod 640 ${txtFiles}
    propertiesFiles=$(find ${jrePath}/ -name "*.properties")
    chmod 640 ${propertiesFiles}
    gifFiles=$(find ${jrePath}/ -name "*.gif")
    chmod 640 ${gifFiles}
    scriptExelog "INFO:chmod jre permission finished! jrePath: ${jrePath}.[Line:${LINENO}]" ${FUNCNAME} ${scriptName}
    return 0
}

#===============================================================================
# 函数：is_link
# 功能：判断参数路径是否包含链接
# 参数：文件(夹)路径
#================================================================================
function is_link()
{
    local target="$1"
    if [ -z "${target}" ];then
        return 0
    fi
    local real_target=$(readlink -f "${target}")

    target=$(echo $target | sed 's@//@/@g')
    if [[ ! -z "${real_target}" && "${real_target}" != "${target}" ]];then
        return 1
    fi
}

#0代表单机、1代表主机、2代表备机
function getCurrentRole()
{
  # 部署单个管理节点时，备节点IP地址为"--"或主节点IP，浮动IP地址等于管理节点固定IP地址
    if [[ x"${STANDBY_IP}" == x"--" ]] || [[ x"${STANDBY_IP}" == x"${ACTIVE_IP}" ]]; then
        return 0
    fi
    ip addr show | fgrep -w "${SERVICE_FLOAT_IP}" 2>>"${SHELL_LOG_FULL_PATH}"
    if [ $? -eq 0 ];then
        return 1
    fi
    return 2
}

function getRestConvertPid()
{
   local pid=`ps aux|grep RestConvert.jar | grep -v grep | grep -v PID | awk '{print $2}'`
   echo $pid
}

function isRestCovertRunning()
{
	local pid=$(getRestConvertPid)
	if [[ x"$pid" == "x" ]]; then
	  return 1
	fi
	return 0
}

#检查进程的监听是否符合预期
function checkSocketListen()
{
  local pid=$(getRestConvertPid)
  if [[ x"$pid" == "x" ]]; then
	  log_warn "restConvert is not running,no need to check socket listen"
	  return 1
	fi
	local ip_ports=`netstat -anp | grep ${pid} | grep LISTEN | awk '{print $4}'`
	local expect_ip_port="${SERVICE_FLOAT_IP}:8999"
  for ip_port in $ip_ports;do
    if [[ "${ip_port}" == "${expect_ip_port}" ]] || [[ "${ip_port}" == "127.0.0.1:8999" ]] || [[ "${ip_port}" == "::1:8999" ]] ;then
      return 0
    fi
  done
  log_warn "ip_ports is ${ip_ports},floatip is ${expect_ip_port}"
  return 1
}

#等待HA拉起RestConvert，连续检查30s
function testRestCovert()
{
	for i in $(seq 10)
	do
		log_info "check RestConvert status count : $i"
		isRestCovertRunning
		if [ $? -ne 0 ]; then
		   log_warn "RestConvert is not running"
		   sleep 3
		   continue
		fi
		checkSocketListen
		if [ $? -ne 0 ]; then
		   log_warn "RestConvert socket listen is abnormal"
		   sleep 3
		   continue
		fi
		log_info "RestConvert status is normal"
		return 0
	done
	return 1
}

function add_crontab_file()
{
    flock -w 60 506 ||  { scriptExelog "wait 60s, get crontad_file lock time out" ${FUNCNAME} ${scriptName} ;return 1; }

    local commandDiscribe=$1

    sed -i '$a\'"${commandDiscribe}" ${CRONTAB_FILE_PATH}
    return $?
} 506<>${CRONTAB_LOCK_FILE}

function delete_crontab_file()
{
    flock -w 60 506 ||  { scriptExelog "wait 60s, get crontad_file lock time out" ${FUNCNAME} ${scriptName} ;return 1; }

    local commandDiscribe
    local outputPath

    if [ $# -eq 1 ] ; then
        commandDiscribe=$1
        sed -i "/${commandDiscribe}/d" ${CRONTAB_FILE_PATH}
        if [ $? -ne 0 ] ; then
            return 1
        fi
    fi
    if [ $# -eq 2 ];then
        commandDiscribe=$1
        outputPath=$2
        sed -i "/${commandDiscribe}/d" ${CRONTAB_FILE_PATH} 2>&1 >> ${outputPath}
        if [ $? -ne 0 ] ; then
            return 1
        fi
    fi

    return 0
} 506<>${CRONTAB_LOCK_FILE}